/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.method;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.Invoker;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.LookupKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class MethodInvoker
implements Invoker {
    private final Method method;
    private final Type[] paramTypes;
    private final Class<?>[] paramTypeClasses;
    private final Type type;
    private final Class<?> typeClass;
    private boolean checkArgs;

    public MethodInvoker(Method method) {
        this.method = ReflectKit.setAccessible(Assert.notNull(method));
        this.paramTypes = TypeKit.getParamTypes(method);
        this.paramTypeClasses = method.getParameterTypes();
        if (this.paramTypes.length == 1) {
            this.type = this.paramTypes[0];
            this.typeClass = this.paramTypeClasses[0];
        } else {
            this.type = method.getReturnType();
            this.typeClass = method.getReturnType();
        }
    }

    public static MethodInvoker of(Method method) {
        return null == method ? null : new MethodInvoker(method);
    }

    public static <T> T invoke(Object object, Method method, Object ... args) throws InternalException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        return MethodInvoker.invokeExact(object, method, MethodKit.actualArgs(method, args));
    }

    public static <T> T invokeExact(Object object, Method method, Object ... args) throws InternalException {
        MethodHandle handle;
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        try {
            handle = LookupKit.unreflectMethod(method);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
        if (null != object) {
            handle = handle.bindTo(object);
        }
        return MethodInvoker.invokeHandle(handle, args);
    }

    public static <T> T invokeHandle(MethodHandle methodHandle, Object ... args) {
        try {
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Type[] getParamTypes() {
        return this.paramTypes;
    }

    public Type getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public MethodInvoker setCheckArgs(boolean checkArgs) {
        this.checkArgs = checkArgs;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) throws InternalException {
        Method method;
        if (this.checkArgs) {
            this.checkArgs(args);
        }
        if (ModifierKit.isStatic(method = this.method)) {
            target = null;
        }
        Object[] actualArgs = MethodKit.actualArgs(method, args);
        try {
            return MethodInvoker.invokeExact(target, method, actualArgs);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(target, actualArgs);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new InternalException(ex);
            }
        }
    }

    public <T> T invokeStatic(Object ... args) throws InternalException {
        return this.invoke(null, args);
    }

    private void checkArgs(Object[] args) {
        Class<?>[] paramTypeClasses = this.paramTypeClasses;
        if (null != args) {
            Assert.isTrue(args.length == paramTypeClasses.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, paramTypeClasses.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypeClasses[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassKit.getDefaultValue(type);
            }
        }
    }
}

