/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.set.UniqueKeySet;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ModifierKit;

public class MethodReflect {
    private final Class<?> clazz;
    private volatile Method[] publicMethods;
    private volatile Method[] declaredMethods;
    private volatile Method[] allMethods;

    public MethodReflect(Class<?> clazz) {
        this.clazz = Assert.notNull(clazz);
    }

    public static MethodReflect of(Class<?> clazz) {
        return new MethodReflect(clazz);
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ModifierKit.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public synchronized void clearCaches() {
        this.publicMethods = null;
        this.declaredMethods = null;
        this.allMethods = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Method[] getPublicMethods(Predicate<Method> predicate) {
        if (null != this.publicMethods) return ArrayKit.filter(this.publicMethods, predicate);
        Class<MethodReflect> clazz = MethodReflect.class;
        synchronized (MethodReflect.class) {
            if (null != this.publicMethods) return ArrayKit.filter(this.publicMethods, predicate);
            this.publicMethods = this.clazz.getMethods();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayKit.filter(this.publicMethods, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Method[] getDeclaredMethods(Predicate<Method> predicate) {
        if (null != this.declaredMethods) return ArrayKit.filter(this.declaredMethods, predicate);
        Class<MethodReflect> clazz = MethodReflect.class;
        synchronized (MethodReflect.class) {
            if (null != this.declaredMethods) return ArrayKit.filter(this.declaredMethods, predicate);
            this.declaredMethods = this.clazz.getDeclaredMethods();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayKit.filter(this.declaredMethods, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Method[] getAllMethods(Predicate<Method> predicate) {
        if (null != this.allMethods) return ArrayKit.filter(this.allMethods, predicate);
        Class<MethodReflect> clazz = MethodReflect.class;
        synchronized (MethodReflect.class) {
            if (null != this.allMethods) return ArrayKit.filter(this.allMethods, predicate);
            this.allMethods = this.getMethodsDirectly(true, true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayKit.filter(this.allMethods, predicate);
        }
    }

    public Method[] getMethodsDirectly(boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Class<?> clazz = this.clazz;
        if (clazz.isInterface()) {
            return withSupers ? clazz.getMethods() : clazz.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, MethodReflect::getUniqueKey);
        Class<?> searchType = clazz;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(MethodReflect.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }
}

