/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.thread;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Wrapper;

public class DelegatedExecutorService
extends AbstractExecutorService
implements Wrapper<ExecutorService> {
    private final ExecutorService raw;

    public DelegatedExecutorService(ExecutorService executor) {
        this.raw = Assert.notNull(executor, "executor must be not null !", new Object[0]);
    }

    @Override
    public void execute(Runnable command) {
        this.raw.execute(command);
    }

    @Override
    public void shutdown() {
        this.raw.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.raw.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.raw.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.raw.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.raw.awaitTermination(timeout, unit);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.raw.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.raw.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.raw.submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.raw.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.raw.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.raw.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.raw.invokeAny(tasks, timeout, unit);
    }

    @Override
    public ExecutorService getRaw() {
        return this.raw;
    }
}

