/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.lang.thread.threadlocal.SpecificThread;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class NamedThreadFactory
implements ThreadFactory {
    protected final String prefix;
    protected final ThreadGroup group;
    protected final boolean daemon;
    protected final int priority;
    protected final AtomicInteger nextId = new AtomicInteger(1);
    protected final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory() {
        this(null, null, 5);
    }

    public NamedThreadFactory(Class<?> clazz) {
        this(clazz, null, 5);
    }

    public NamedThreadFactory(String prefix) {
        this(null, prefix, 5);
    }

    public NamedThreadFactory(Class<?> clazz, String prefix, int priority) {
        this(clazz, prefix, true, priority);
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        this(null, prefix, null, daemon, 5);
    }

    public NamedThreadFactory(Class<?> clazz, String prefix, boolean daemon, int priority) {
        this(clazz, prefix, null, daemon, priority);
    }

    public NamedThreadFactory(String prefix, ThreadGroup group, boolean daemon) {
        this(null, prefix, group, daemon, 5, null);
    }

    public NamedThreadFactory(Class<?> clazz, String prefix, ThreadGroup group, boolean daemon, int priority) {
        this(clazz, prefix, group, daemon, priority, null);
    }

    public NamedThreadFactory(String prefix, ThreadGroup group, boolean daemon, Thread.UncaughtExceptionHandler handler) {
        this(null, prefix, group, daemon, 5, handler);
    }

    public NamedThreadFactory(Class<?> clazz, String prefix, ThreadGroup group, boolean daemon, int priority, Thread.UncaughtExceptionHandler handler) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("priority: " + priority + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        if (ObjectKit.isEmpty(clazz) && StringKit.isEmpty(prefix)) {
            this.prefix = "X";
        } else {
            String string = this.prefix = StringKit.isBlank(prefix) ? ClassKit.getClassName(clazz, true) : prefix;
        }
        if (null == group) {
            group = Thread.currentThread().getThreadGroup();
        }
        this.group = group;
        this.daemon = daemon;
        this.priority = priority;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.newThread(r, StringKit.format("{}{}", this.prefix, this.nextId.getAndIncrement()));
        if (!t.isDaemon()) {
            if (this.daemon) {
                t.setDaemon(true);
            }
        } else if (!this.daemon) {
            t.setDaemon(false);
        }
        if (t.getPriority() != this.priority) {
            t.setPriority(this.priority);
        }
        if (null != this.handler) {
            t.setUncaughtExceptionHandler(this.handler);
        }
        return t;
    }

    protected Thread newThread(Runnable r, String name) {
        return new SpecificThread(this.group, r, name);
    }
}

