/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.math;

public class RomanNumberFormatter {
    public static String intToRoman(int num) {
        if (num > 3999 || num < 1) {
            return "";
        }
        String[] thousands = new String[]{"", "M", "MM", "MMM"};
        String[] hundreds = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] ones = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        return thousands[num / 1000] + hundreds[num % 1000 / 100] + tens[num % 100 / 10] + ones[num % 10];
    }

    public static int romanToInt(String roman) {
        int result = 0;
        int prevValue = 0;
        char[] charArray = roman.toCharArray();
        for (int i = charArray.length - 1; i >= 0; --i) {
            char c = charArray[i];
            int currValue = switch (c) {
                case 'I' -> 1;
                case 'V' -> 5;
                case 'X' -> 10;
                case 'L' -> 50;
                case 'C' -> 100;
                case 'D' -> 500;
                case 'M' -> 1000;
                default -> throw new IllegalArgumentException("Invalid Roman character: " + c);
            };
            result = currValue < prevValue ? (result -= currValue) : (result += currValue);
            prevValue = currValue;
        }
        return result;
    }
}

