/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net;

import java.io.IOException;
import org.miaixz.bus.core.xyz.StringKit;

public enum Protocol {
    PIPE("pipe"),
    SOCKET("socket"),
    TCP("tcp"),
    UDP("udp"),
    HTTP("http"),
    HTTP_1_0("HTTP/1.0"),
    HTTP_1_1("HTTP/1.1"),
    HTTP_2("h2"),
    HTTP_3("h3"),
    SPDY_3("spdy/3.1"),
    H2_PRIOR_KNOWLEDGE("h2_prior_knowledge"),
    QUIC("quic"),
    SOAP_1_1("soap 1.1 protocol"),
    SOAP_1_2("SOAP 1.2 Protocol"),
    WS("ws"),
    WSS("wss"),
    HTTPS("https"),
    SSL("ssl"),
    SSLv2("SSLv2"),
    SSLv3("SSLv3"),
    TLS("tls"),
    TLSv1("TLSv1"),
    TLSv1_1("TLSv1.1"),
    TLSv1_2("TLSv1.2"),
    TLSv1_3("TLSv1.3"),
    DICOM("dicom"),
    HL7("hl7"),
    OIDC("OIDC"),
    SAML("SAML"),
    LDAP("LDAP");

    public static final String HTTP_PREFIX;
    public static final String HTTPS_PREFIX;
    public static final String WS_PREFIX;
    public static final String WSS_PREFIX;
    public static final String HOST_IPV4 = "127.0.0.1";
    public static final String HOST_LOCAL = "localhost";
    public static final String IPV4_STR_MIN = "0.0.0.0";
    public static final String IPV4_STR_MAX = "255.255.255.255";
    public static final long IPV4_NUM_MAX = 0xFFFFFFFFL;
    public static final String IPV4_UNUSED_STR_MAX = "0.255.255.255";
    public final String name;

    private Protocol(String name) {
        this.name = name;
    }

    public static Protocol get(String protocol) throws IOException {
        if (StringKit.isEmpty(protocol)) {
            throw new IOException("Protocol cannot be null or empty");
        }
        switch (protocol) {
            case "HTTP/1.0": {
                return HTTP_1_0;
            }
            case "HTTP/1.1": {
                return HTTP_1_1;
            }
            case "h2_prior_knowledge": {
                return H2_PRIOR_KNOWLEDGE;
            }
            case "h2": {
                return HTTP_2;
            }
            case "spdy/3.1": {
                return SPDY_3;
            }
            case "quic": {
                return QUIC;
            }
            case "soap 1.1 protocol": {
                return SOAP_1_1;
            }
            case "SOAP 1.2 Protocol": {
                return SOAP_1_2;
            }
        }
        throw new IOException("Unexpected protocol: " + protocol);
    }

    public static boolean isHttp(String url) {
        if (StringKit.isEmpty(url)) {
            return false;
        }
        return url.startsWith(HTTP_PREFIX) || url.startsWith("http%3A%2F%2F");
    }

    public static boolean isHttps(String url) {
        if (StringKit.isEmpty(url)) {
            return false;
        }
        return url.startsWith(HTTPS_PREFIX) || url.startsWith("https%3A%2F%2F");
    }

    public static boolean isLocalHost(String url) {
        return StringKit.isEmpty(url) || url.contains(HOST_IPV4) || url.contains(HOST_LOCAL);
    }

    public static boolean isHttpsOrLocalHost(String url) {
        if (StringKit.isEmpty(url)) {
            return false;
        }
        return Protocol.isHttps(url) || Protocol.isLocalHost(url);
    }

    public boolean isTcp() {
        return this != UDP;
    }

    public boolean isSecure() {
        return this == HTTPS || this == WSS || this == TLS || this == SSL || this == TLSv1 || this == TLSv1_1 || this == TLSv1_2 || this == TLSv1_3 || this == SSLv2 || this == SSLv3;
    }

    public String toString() {
        return this.name;
    }

    static {
        HTTP_PREFIX = Protocol.HTTP.name + "://";
        HTTPS_PREFIX = Protocol.HTTPS.name + "://";
        WS_PREFIX = Protocol.WS.name + "://";
        WSS_PREFIX = Protocol.WSS.name + "://";
    }
}

