/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.tls;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.miaixz.bus.core.lang.exception.CryptoException;
import org.miaixz.bus.core.xyz.StringKit;

public class AnyKeyManager {
    public static KeyManagerFactory getDefaultKeyManagerFactory() {
        return AnyKeyManager.getDefaultKeyManagerFactory(null);
    }

    public static KeyManagerFactory getDefaultKeyManagerFactory(Provider provider) {
        return AnyKeyManager.getKeyManagerFactory(null, provider);
    }

    public static KeyManagerFactory getKeyManagerFactory(String algorithm, Provider provider) {
        if (StringKit.isBlank(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        try {
            return null == provider ? KeyManagerFactory.getInstance(algorithm) : KeyManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, char[] password, String algorithm, Provider provider) {
        KeyManagerFactory keyManagerFactory = AnyKeyManager.getKeyManagerFactory(algorithm, provider);
        try {
            keyManagerFactory.init(keyStore, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
        return keyManagerFactory;
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, char[] password) {
        return AnyKeyManager.getKeyManagers(keyStore, password, null, null);
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, char[] password, String algorithm, Provider provider) {
        return AnyKeyManager.getKeyManagerFactory(keyStore, password, algorithm, provider).getKeyManagers();
    }
}

