/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.tls;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.miaixz.bus.core.lang.exception.CryptoException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class AnyTrustManager
extends X509ExtendedTrustManager {
    public static final AnyTrustManager INSTANCE = new AnyTrustManager();
    public static final X509TrustManager[] TRUST_ANYS = new X509TrustManager[]{INSTANCE};
    private static final X509Certificate[] EMPTY_X509_CERTIFICATE_ARRAY = new X509Certificate[0];

    public static X509TrustManager getDefaultTrustManager() {
        return AnyTrustManager.getTrustManager(null, null);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, Provider provider) {
        return AnyTrustManager.getTrustManager(keyStore, null, provider);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManager[] tms;
        for (TrustManager tm : tms = AnyTrustManager.getTrustManagers(keyStore, algorithm, provider)) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public static TrustManager[] getDefaultTrustManagers() {
        return AnyTrustManager.getTrustManagers(null);
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore) {
        return AnyTrustManager.getTrustManagers(keyStore, null, null);
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore, String algorithm, Provider provider) {
        return AnyTrustManager.getTrustManagerFactory(keyStore, algorithm, provider).getTrustManagers();
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManagerFactory tmf;
        if (StringKit.isEmpty(algorithm)) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            tmf = null == provider ? TrustManagerFactory.getInstance(algorithm) : TrustManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        return tmf;
    }

    public static KeyStore createKeyStore(X509Certificate ... certs) throws KeyStoreException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try {
            ks.load(null);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
        for (X509Certificate cert : certs) {
            ks.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
        }
        return ks;
    }

    public static KeyStore loadKeyStore(String type, String url, String password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        return AnyTrustManager.loadKeyStore(type, url, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String type, String url, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(type);
        InputStream in = IoKit.openFileOrURL(url);
        try {
            ks.load(in, password);
        }
        finally {
            IoKit.close(in);
        }
        return ks;
    }

    public static KeyManager createKeyManager(String type, String url, char[] storePassword, char[] keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return AnyTrustManager.createKeyManager(AnyTrustManager.loadKeyStore(type, url, storePassword), keyPassword);
    }

    public static KeyManager createKeyManager(String type, String url, String storePassword, String keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return AnyTrustManager.createKeyManager(AnyTrustManager.loadKeyStore(type, url, storePassword), keyPassword);
    }

    public static KeyManager createKeyManager(KeyStore ks, String password) throws UnrecoverableKeyException, KeyStoreException {
        return AnyTrustManager.createKeyManager(ks, password.toCharArray());
    }

    public static KeyManager createKeyManager(KeyStore ks, char[] password) throws UnrecoverableKeyException, KeyStoreException {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            KeyManager[] kms = kmf.getKeyManagers();
            return kms.length > 0 ? kms[0] : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TrustManager createTrustManager(KeyStore ks) throws KeyStoreException {
        try {
            TrustManagerFactory kmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf.init(ks);
            TrustManager[] tms = kmf.getTrustManagers();
            return tms.length > 0 ? tms[0] : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TrustManager createTrustManager(X509Certificate ... certs) throws KeyStoreException {
        return AnyTrustManager.createTrustManager(AnyTrustManager.createKeyStore(certs));
    }

    public static TrustManager createTrustManager(String type, String url, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return AnyTrustManager.createTrustManager(AnyTrustManager.loadKeyStore(type, url, password));
    }

    public static TrustManager createTrustManager(String type, String url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return AnyTrustManager.createTrustManager(AnyTrustManager.loadKeyStore(type, url, password));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_X509_CERTIFICATE_ARRAY;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
    }
}

