/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.tls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.miaixz.bus.core.net.Protocol;

public enum TlsVersion {
    TLSv1_3(Protocol.TLSv1_3.name),
    TLSv1_2(Protocol.TLSv1_2.name),
    TLSv1_1(Protocol.TLSv1_1.name),
    TLSv1(Protocol.TLSv1.name),
    SSLv3(Protocol.SSLv3.name);

    public final String javaName;

    private TlsVersion(String javaName) {
        this.javaName = javaName;
    }

    public static TlsVersion forJavaName(String javaName) {
        if (Protocol.TLSv1_3.name.equals(javaName)) {
            return TLSv1_3;
        }
        if (Protocol.TLSv1_2.name.equals(javaName)) {
            return TLSv1_2;
        }
        if (Protocol.TLSv1_1.name.equals(javaName)) {
            return TLSv1_1;
        }
        if (Protocol.TLSv1.name.equals(javaName)) {
            return TLSv1;
        }
        if (Protocol.SSLv3.name.equals(javaName)) {
            return SSLv3;
        }
        throw new IllegalArgumentException("Unexpected TLS version: " + javaName);
    }

    public static List<TlsVersion> forJavaNames(String ... tlsVersions) {
        ArrayList<TlsVersion> result = new ArrayList<TlsVersion>(tlsVersions.length);
        for (String tlsVersion : tlsVersions) {
            result.add(TlsVersion.forJavaName(tlsVersion));
        }
        return Collections.unmodifiableList(result);
    }

    public String javaName() {
        return this.javaName;
    }
}

