/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UrlDecoder
implements Serializable {
    private static final long serialVersionUID = 2852231876163L;

    public static String decodeForPath(String text, Charset charset) {
        return UrlDecoder.decode(text, charset, false);
    }

    public static String decode(String text) {
        return UrlDecoder.decode(text, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decode(String text, Charset charset) {
        return UrlDecoder.decode(text, charset, true);
    }

    public static String decode(String text, boolean isPlusToSpace) {
        return UrlDecoder.decode(text, org.miaixz.bus.core.lang.Charset.UTF_8, isPlusToSpace);
    }

    public static String decode(String text, Charset charset, boolean isPlusToSpace) {
        if (null == charset) {
            return text;
        }
        if (null == text) {
            return null;
        }
        int length = text.length();
        if (0 == length) {
            return "";
        }
        StringBuilder result = new StringBuilder(length / 3);
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            int c = text.charAt(i);
            if (37 == c || CharKit.isHexChar((char)c)) continue;
            if (i > begin) {
                result.append(UrlDecoder.decodeSub(text, begin, i, charset, isPlusToSpace));
            }
            if (43 == c && isPlusToSpace) {
                c = 32;
            }
            result.append((char)c);
            begin = i + 1;
        }
        if (begin < length) {
            result.append(UrlDecoder.decodeSub(text, begin, length, charset, isPlusToSpace));
        }
        return result.toString();
    }

    public static byte[] decode(byte[] bytes) {
        return UrlDecoder.decode(bytes, true);
    }

    public static byte[] decode(byte[] bytes, boolean isPlusToSpace) {
        if (bytes == null) {
            return null;
        }
        FastByteArrayOutputStream buffer = new FastByteArrayOutputStream(bytes.length / 3);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = CharKit.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = CharKit.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static String decodeSub(String text, int begin, int end, Charset charset, boolean isPlusToSpace) {
        return new String(UrlDecoder.decode(text.substring(begin, end).getBytes(org.miaixz.bus.core.lang.Charset.ISO_8859_1), isPlusToSpace), charset);
    }

    public static Map<String, String> decodeMap(String params, String charset) {
        Map<String, List<String>> paramsMap = UrlDecoder.decodeObject(params, charset);
        HashMap<String, String> result = MapKit.newHashMap(paramsMap.size());
        Iterator<Map.Entry<String, List<String>>> iterator = paramsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            List<String> list;
            Map.Entry<String, List<String>> entry;
            result.put(entry.getKey(), CollKit.isEmpty(list = (entry = iterator.next()).getValue()) ? null : list.get(0));
        }
        return result;
    }

    public static Map<String, List<String>> decodeObject(String params, String charset) {
        int i;
        if (StringKit.isBlank(params)) {
            return Collections.emptyMap();
        }
        int pathEndPos = params.indexOf(63);
        if (pathEndPos > -1) {
            params = StringKit.subSuf(params, pathEndPos + 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        int len = params.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = params.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = params.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                UrlDecoder.addParam(map, params.substring(pos, i), "", charset);
            } else if (null != name) {
                UrlDecoder.addParam(map, name, params.substring(pos, i), charset);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (null == name) {
                UrlDecoder.addParam(map, params.substring(pos, i), "", charset);
            } else {
                UrlDecoder.addParam(map, name, params.substring(pos, i), charset);
            }
        } else if (null != name) {
            UrlDecoder.addParam(map, name, "", charset);
        }
        return map;
    }

    private static void addParam(Map<String, List<String>> params, String name, String value, String charset) {
        name = UrlDecoder.decode(name, org.miaixz.bus.core.lang.Charset.parse(charset));
        value = UrlDecoder.decode(value, org.miaixz.bus.core.lang.Charset.parse(charset));
        List<String> values = params.get(name);
        if (null == values) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }
}

