/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.miaixz.bus.core.center.map.TableMap;
import org.miaixz.bus.core.codec.PercentCodec;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UrlQuery {
    public static final PercentCodec ALL = PercentCodec.Builder.of(RFC3986.UNRESERVED).removeSafe('~').addSafe('*').setEncodeSpaceAsPlus(true).build();
    private final TableMap<CharSequence, CharSequence> query;
    private EncodeMode encodeMode;

    public UrlQuery(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        if (MapKit.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
        this.encodeMode = ObjectKit.defaultIfNull(encodeMode, EncodeMode.NORMAL);
    }

    public static UrlQuery of(String query, Charset charset) {
        return UrlQuery.of(query, charset, true);
    }

    public static UrlQuery of(String query, Charset charset, boolean autoRemovePath) {
        return UrlQuery.of(query, charset, autoRemovePath, null);
    }

    public static UrlQuery of(String query, Charset charset, boolean autoRemovePath, EncodeMode encodeMode) {
        return UrlQuery.of(encodeMode).parse(query, charset, autoRemovePath);
    }

    public static UrlQuery of() {
        return UrlQuery.of(EncodeMode.NORMAL);
    }

    public static UrlQuery of(EncodeMode encodeMode) {
        return new UrlQuery(null, encodeMode);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        return UrlQuery.of(queryMap, null);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        return new UrlQuery(queryMap, encodeMode);
    }

    private static String toString(Object value) {
        String result = value instanceof Iterable ? CollKit.join((Iterable)value, ",") : (value instanceof Iterator ? IteratorKit.join((Iterator)value, ",") : Convert.toString(value));
        return result;
    }

    public UrlQuery setEncodeMode(EncodeMode encodeMode) {
        this.encodeMode = encodeMode;
        return this;
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toString(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapKit.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery remove(CharSequence key) {
        this.query.remove(key);
        return this;
    }

    public UrlQuery parse(String query, Charset charset) {
        return this.parse(query, charset, true);
    }

    public UrlQuery parse(String query, Charset charset, boolean autoRemovePath) {
        int pathEndPos;
        if (StringKit.isBlank(query)) {
            return this;
        }
        if (autoRemovePath && ((pathEndPos = query.indexOf(63)) > -1 ? StringKit.isBlank(query = StringKit.subSuf(query, pathEndPos + 1)) : StringKit.startWith((CharSequence)query, "http://") || StringKit.startWith((CharSequence)query, "https://"))) {
            return this;
        }
        return this.doParse(query, charset);
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapKit.view(this.query);
    }

    public CharSequence get(CharSequence key) {
        if (MapKit.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(key);
    }

    public String build(Charset charset) {
        switch (this.encodeMode.ordinal()) {
            case 1: {
                return this.build(ALL, ALL, charset);
            }
            case 2: {
                return this.build(RFC3986.QUERY_PARAM_NAME_STRICT, RFC3986.QUERY_PARAM_VALUE_STRICT, charset);
            }
        }
        return this.build(RFC3986.QUERY_PARAM_NAME, RFC3986.QUERY_PARAM_VALUE, charset);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset) {
        if (MapKit.isEmpty(this.query)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence name = entry.getKey();
            if (null == name) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(keyCoder.encode(name, charset, new char[0]));
            CharSequence value = entry.getValue();
            if (null == value) continue;
            sb.append("=").append(valueCoder.encode(value, charset, new char[0]));
        }
        return sb.toString();
    }

    private UrlQuery doParse(String query, Charset charset) {
        int i;
        int len = query.length();
        String name = null;
        int pos = 0;
        block4: for (i = 0; i < len; ++i) {
            char c = query.charAt(i);
            switch (c) {
                case '=': {
                    if (null != name) continue block4;
                    name = query.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(name, query.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(query.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                }
            }
        }
        this.addParam(name, query.substring(pos, i), charset);
        return this;
    }

    private void addParam(String key, String value, Charset charset) {
        boolean isFormUrlEncoded;
        boolean bl = isFormUrlEncoded = EncodeMode.FORM_URL_ENCODED == this.encodeMode;
        if (null != key) {
            String actualKey = UrlDecoder.decode(key, charset, isFormUrlEncoded);
            this.query.put(actualKey, StringKit.toStringOrEmpty(UrlDecoder.decode(value, charset, isFormUrlEncoded)));
        } else if (null != value) {
            this.query.put(UrlDecoder.decode(value, charset, isFormUrlEncoded), null);
        }
    }

    public String toString() {
        return this.build(null);
    }

    public static enum EncodeMode {
        NORMAL,
        FORM_URL_ENCODED,
        STRICT;

    }
}

