/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.compare.VersionCompare;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.CharsValidator;
import org.miaixz.bus.core.text.NamingCase;
import org.miaixz.bus.core.text.OffsetMatcher;
import org.miaixz.bus.core.text.StringRepeater;
import org.miaixz.bus.core.text.StringSplitter;
import org.miaixz.bus.core.text.StringTrimer;
import org.miaixz.bus.core.text.finder.CharFinder;
import org.miaixz.bus.core.text.finder.LengthFinder;
import org.miaixz.bus.core.text.finder.MatcherFinder;
import org.miaixz.bus.core.text.finder.PatternFinder;
import org.miaixz.bus.core.text.finder.StringFinder;
import org.miaixz.bus.core.text.finder.TextFinder;
import org.miaixz.bus.core.text.placeholder.StringFormatter;
import org.miaixz.bus.core.text.replacer.CharRangeReplacer;
import org.miaixz.bus.core.text.replacer.SearchReplacer;
import org.miaixz.bus.core.text.replacer.StringRangeReplacer;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.PatternKit;

public class CharsBacker
extends CharsValidator {
    public static String toString(Object object) {
        return String.valueOf(object);
    }

    public static String toStringOrNull(Object object) {
        return null == object ? null : object.toString();
    }

    public static String toStringOrEmpty(Object object) {
        return null == object ? "" : object.toString();
    }

    public static CharSequence emptyIfNull(CharSequence text) {
        return null == text ? "" : text;
    }

    public static <T extends CharSequence> T nullIfEmpty(T text) {
        return CharsBacker.isEmpty(text) ? null : (T)text;
    }

    public static <T extends CharSequence> T nullIfBlank(T text) {
        return CharsBacker.isBlank(text) ? null : (T)text;
    }

    public static <T extends CharSequence> T defaultIfNull(T text, T defaultValue) {
        return ObjectKit.defaultIfNull(text, defaultValue);
    }

    public static <T extends CharSequence> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        return (T)((CharSequence)ObjectKit.defaultIfNull(source, defaultSupplier));
    }

    public static <T extends CharSequence, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, Supplier<? extends R> defaultSupplier) {
        return ObjectKit.defaultIfNull(source, handler, defaultSupplier);
    }

    public static <T extends CharSequence> T defaultIfEmpty(T text, T defaultValue) {
        return CharsBacker.isEmpty(text) ? defaultValue : text;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T text, Supplier<? extends T> defaultSupplier) {
        return (T)(CharsBacker.isEmpty(text) ? (CharSequence)defaultSupplier.get() : text);
    }

    public static <T extends CharSequence, V> V defaultIfEmpty(T text, Function<T, V> handler, Supplier<? extends V> defaultSupplier) {
        return CharsBacker.isEmpty(text) ? defaultSupplier.get() : handler.apply(text);
    }

    public static <T extends CharSequence> T defaultIfBlank(T text, T defaultValue) {
        return CharsBacker.isBlank(text) ? defaultValue : text;
    }

    public static <T extends CharSequence, V> V defaultIfBlank(T text, Function<T, V> handler, Supplier<? extends V> defaultSupplier) {
        if (CharsBacker.isBlank(text)) {
            return defaultSupplier.get();
        }
        return handler.apply(text);
    }

    public static String trim(CharSequence text) {
        return StringTrimer.TRIM_BLANK.apply(text);
    }

    public static String trimToEmpty(CharSequence text) {
        return text == null ? "" : CharsBacker.trim(text);
    }

    public static String trimToNull(CharSequence text) {
        String trim = CharsBacker.trim(text);
        return "".equals(trim) ? null : trim;
    }

    public static String trimPrefix(CharSequence text) {
        return StringTrimer.TRIM_PREFIX_BLANK.apply(text);
    }

    public static String trimSuffix(CharSequence text) {
        return StringTrimer.TRIM_SUFFIX_BLANK.apply(text);
    }

    public static String trim(CharSequence text, StringTrimer.TrimMode mode) {
        return new StringTrimer(mode, CharKit::isBlankChar).apply(text);
    }

    public static String trim(CharSequence text, StringTrimer.TrimMode mode, Predicate<Character> predicate) {
        return new StringTrimer(mode, predicate).apply(text);
    }

    public static boolean startWith(CharSequence text, char c) {
        if (CharsBacker.isEmpty(text)) {
            return false;
        }
        return c == text.charAt(0);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix) {
        return CharsBacker.startWith(text, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence text, CharSequence prefix) {
        return CharsBacker.startWith(text, prefix, false, true);
    }

    public static boolean startWithIgnoreCase(CharSequence text, CharSequence prefix) {
        return CharsBacker.startWith(text, prefix, true);
    }

    public static boolean startWithAny(CharSequence text, CharSequence ... prefixes) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharsBacker.startWith(text, prefix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAnyIgnoreCase(CharSequence text, CharSequence ... prefixes) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharsBacker.startWith(text, prefix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase) {
        return CharsBacker.startWith(text, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        return new OffsetMatcher(ignoreCase, ignoreEquals, true).test(text, prefix);
    }

    public static boolean endWith(CharSequence text, char c) {
        if (CharsBacker.isEmpty(text)) {
            return false;
        }
        return c == text.charAt(text.length() - 1);
    }

    public static boolean endWith(CharSequence text, CharSequence suffix) {
        return CharsBacker.endWith(text, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence text, CharSequence suffix) {
        return CharsBacker.endWith(text, suffix, true);
    }

    public static boolean endWithAny(CharSequence text, CharSequence ... suffixes) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharsBacker.endWith(text, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence text, CharSequence ... suffixes) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharsBacker.endWith(text, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence text, CharSequence suffix, boolean ignoreCase) {
        return CharsBacker.endWith(text, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence text, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        return new OffsetMatcher(ignoreCase, ignoreEquals, false).test(text, suffix);
    }

    public static boolean contains(CharSequence text, char args) {
        return CharsBacker.indexOf(text, args) > -1;
    }

    public static boolean contains(CharSequence text, CharSequence args) {
        if (null == text || null == args) {
            return false;
        }
        return text.toString().contains(args);
    }

    public static boolean containsAny(CharSequence text, CharSequence ... args) {
        return null != CharsBacker.getContainsString(text, args);
    }

    public static boolean containsAny(CharSequence text, char ... args) {
        if (CharsBacker.isNotEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayKit.contains(args, text.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence text, char ... args) {
        if (CharsBacker.isNotEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayKit.contains(args, text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence text) {
        if (null == text) {
            return false;
        }
        int length = text.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharKit.isBlankChar(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsString(CharSequence text, CharSequence ... args) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return null;
        }
        for (CharSequence checkStr : args) {
            if (!CharsBacker.contains(text, checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence text, CharSequence args) {
        if (null == text) {
            return null == args;
        }
        return CharsBacker.indexOfIgnoreCase(text, args) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence text, CharSequence ... args) {
        return null != CharsBacker.getContainsStrIgnoreCase(text, args);
    }

    public static String getContainsStrIgnoreCase(CharSequence text, CharSequence ... args) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return null;
        }
        for (CharSequence testStr : args) {
            if (!CharsBacker.containsIgnoreCase(text, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static boolean containsAll(CharSequence text, CharSequence ... args) {
        if (CharsBacker.isBlank(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence testChar : args) {
            if (CharsBacker.contains(text, testChar)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence text, char args) {
        return CharsBacker.indexOf(text, args, 0);
    }

    public static int indexOf(CharSequence text, char args, int start) {
        if (text instanceof String) {
            return ((String)text).indexOf(args, start);
        }
        return CharsBacker.indexOf(text, args, start, -1);
    }

    public static int indexOf(CharSequence text, char args, int start, int end) {
        if (CharsBacker.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(args).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOf(CharSequence text, Predicate<Character> matcher, int start, int end) {
        if (CharsBacker.isEmpty(text)) {
            return -1;
        }
        return new MatcherFinder(matcher).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence args) {
        return CharsBacker.indexOfIgnoreCase(text, args, 0);
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence args, int fromIndex) {
        return CharsBacker.indexOf(text, args, fromIndex, true);
    }

    public static int indexOf(CharSequence text, CharSequence args, int from, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(args)) {
            if (CharsBacker.equals(text, args)) {
                return 0;
            }
            return -1;
        }
        return StringFinder.of(args, ignoreCase).setText(text).start(from);
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence args) {
        return CharsBacker.lastIndexOfIgnoreCase(text, args, text.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence args, int fromIndex) {
        return CharsBacker.lastIndexOf(text, args, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence text, CharSequence args, int from, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(args)) {
            if (CharsBacker.equals(text, args)) {
                return 0;
            }
            return -1;
        }
        return StringFinder.of(args, ignoreCase).setText(text).setNegative(true).start(from);
    }

    public static int ordinalIndexOf(CharSequence text, CharSequence args, int ordinal) {
        if (text == null || args == null || ordinal <= 0) {
            return -1;
        }
        if (args.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = CharsBacker.indexOf(text, args, index + 1, false)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String removeAll(CharSequence text, CharSequence args) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(args)) {
            return CharsBacker.toStringOrNull(text);
        }
        return text.toString().replace(args, "");
    }

    public static String removeAll(CharSequence text, CharSequence ... args) {
        String result = CharsBacker.toStringOrNull(text);
        if (CharsBacker.isNotEmpty(text)) {
            for (CharSequence remove : args) {
                result = CharsBacker.removeAll((CharSequence)result, remove);
            }
        }
        return result;
    }

    public static String removeAll(CharSequence text, char ... chars) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(chars)) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.filter(text, c -> !ArrayKit.contains(chars, c.charValue()));
    }

    public static String removeAllLineBreaks(CharSequence text) {
        return CharsBacker.removeAll(text, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence text, int preLength) {
        if (text == null) {
            return null;
        }
        if (text.length() > preLength) {
            char first = Character.toLowerCase(text.charAt(preLength));
            if (text.length() > preLength + 1) {
                return first + text.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return text.toString();
    }

    public static String removePreAndLowerFirst(CharSequence text, CharSequence prefix) {
        return CharsBacker.lowerFirst(CharsBacker.removePrefix(text, prefix));
    }

    public static String removePrefix(CharSequence text, CharSequence prefix) {
        return CharsBacker.removePrefix(text, prefix, false);
    }

    public static String removePrefixIgnoreCase(CharSequence text, CharSequence prefix) {
        return CharsBacker.removePrefix(text, prefix, true);
    }

    public static String removePrefix(CharSequence text, CharSequence prefix, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(prefix)) {
            return CharsBacker.toStringOrNull(text);
        }
        String text2 = text.toString();
        if (CharsBacker.startWith(text, prefix, ignoreCase)) {
            return CharsBacker.subSuf(text2, prefix.length());
        }
        return text2;
    }

    public static String removeAllSuffix(CharSequence text, CharSequence suffix) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(suffix)) {
            return CharsBacker.toStringOrNull(text);
        }
        String suffixStr = suffix.toString();
        int suffixLength = suffixStr.length();
        String str2 = text.toString();
        int toIndex = str2.length();
        while (str2.startsWith(suffixStr, toIndex - suffixLength)) {
            toIndex -= suffixLength;
        }
        return CharsBacker.subPre(str2, toIndex);
    }

    public static String removeSuffix(CharSequence text, CharSequence suffix) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(suffix)) {
            return CharsBacker.toStringOrNull(text);
        }
        String text2 = text.toString();
        if (text2.endsWith(suffix.toString())) {
            return CharsBacker.subPre(text2, text2.length() - suffix.length());
        }
        return text2;
    }

    public static String removeSufAndLowerFirst(CharSequence text, CharSequence suffix) {
        return CharsBacker.lowerFirst(CharsBacker.removeSuffix(text, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence text, CharSequence suffix) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(suffix)) {
            return CharsBacker.toStringOrNull(text);
        }
        String text2 = text.toString();
        if (CharsBacker.endWithIgnoreCase(text, suffix)) {
            return CharsBacker.subPre(text2, text2.length() - suffix.length());
        }
        return text2;
    }

    public static String cleanBlank(CharSequence text) {
        return CharsBacker.filter(text, c -> !CharKit.isBlankChar(c.charValue()));
    }

    public static String strip(CharSequence text, CharSequence prefixOrSuffix) {
        if (CharsBacker.equals(text, prefixOrSuffix)) {
            return "";
        }
        return CharsBacker.strip(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return CharsBacker.strip(text, prefix, suffix, false);
    }

    public static String strip(CharSequence text, CharSequence prefix, CharSequence suffix, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int from = 0;
        int to = text.length();
        String text2 = text.toString();
        if (CharsBacker.startWith(text2, prefix, ignoreCase)) {
            from = prefix.length();
        }
        if (CharsBacker.endWith(text2, suffix, ignoreCase)) {
            to -= suffix.length();
        }
        return text2.substring(Math.min(from, to), Math.max(from, to));
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefixOrSuffix) {
        return CharsBacker.stripIgnoreCase(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return CharsBacker.strip(text, prefix, suffix, true);
    }

    public static String addPrefixIfNot(CharSequence text, CharSequence prefix) {
        return CharsBacker.prependIfMissing(text, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence text, CharSequence suffix) {
        return CharsBacker.appendIfMissing(text, suffix, new CharSequence[0]);
    }

    public static String[] cut(CharSequence text, int partLength) {
        return CharsBacker.splitByLength(text, partLength);
    }

    public static String sub(CharSequence text, int fromIndexInclude, int toIndexExclude) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int len = text.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return "";
        }
        return text.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subByCodePoint(CharSequence text, int fromIndex, int toIndex) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        text.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subPreGbk(CharSequence text, int len, CharSequence suffix) {
        return CharsBacker.subPreGbk(text, len, true) + String.valueOf(suffix);
    }

    public static String subPreGbk(CharSequence text, int len, boolean halfUp) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int counterOfDoubleByte = 0;
        byte[] b = ByteKit.toBytes(text, org.miaixz.bus.core.lang.Charset.GBK);
        if (b.length <= len) {
            return text.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            len = halfUp ? ++len : --len;
        }
        return new String(b, 0, len, org.miaixz.bus.core.lang.Charset.GBK);
    }

    public static String subPre(CharSequence text, int toIndexExclude) {
        if (CharsBacker.isEmpty(text) || text.length() == toIndexExclude) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.sub(text, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence text, int fromIndex) {
        if (0 == fromIndex || CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.sub(text, fromIndex, text.length());
    }

    public static String subSufByLength(CharSequence text, int length) {
        if (CharsBacker.isEmpty(text)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return CharsBacker.sub(text, -length, text.length());
    }

    public static String subByLength(String input, int fromIndex, int length) {
        if (CharsBacker.isEmpty(input)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        int toIndex = fromIndex < 0 ? fromIndex - length : fromIndex + length;
        return CharsBacker.sub(input, fromIndex, toIndex);
    }

    public static String subBefore(CharSequence text, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharsBacker.isEmpty(text) || separator == null) {
            return null == text ? null : text.toString();
        }
        String string = text.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? string.lastIndexOf(sep) : string.indexOf(sep);
        if (-1 == pos) {
            return string;
        }
        if (0 == pos) {
            return "";
        }
        return string.substring(0, pos);
    }

    public static String subBefore(CharSequence text, char separator, boolean isLastSeparator) {
        int pos;
        if (CharsBacker.isEmpty(text)) {
            return null == text ? null : "";
        }
        String newText = text.toString();
        int n = pos = isLastSeparator ? newText.lastIndexOf(separator) : newText.indexOf(separator);
        if (-1 == pos) {
            return newText;
        }
        if (0 == pos) {
            return "";
        }
        return newText.substring(0, pos);
    }

    public static String subAfter(CharSequence text, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharsBacker.isEmpty(text)) {
            return null == text ? null : "";
        }
        if (separator == null) {
            return "";
        }
        String newText = text.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? newText.lastIndexOf(sep) : newText.indexOf(sep);
        if (-1 == pos || text.length() - 1 == pos) {
            return "";
        }
        return newText.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence text, char separator, boolean isLastSeparator) {
        int pos;
        if (CharsBacker.isEmpty(text)) {
            return null == text ? null : "";
        }
        String newText = text.toString();
        int n = pos = isLastSeparator ? newText.lastIndexOf(separator) : newText.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return newText.substring(pos + 1);
    }

    public static String subBetween(CharSequence text, CharSequence before, CharSequence after) {
        int end;
        if (text == null || before == null || after == null) {
            return null;
        }
        String text2 = text.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = text2.indexOf(before2);
        if (start != -1 && (end = text2.indexOf(after2, start + before2.length())) != -1) {
            return text2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence text, CharSequence beforeAndAfter) {
        return CharsBacker.subBetween(text, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (CharsBacker.hasEmpty(text, prefix, suffix) || !CharsBacker.contains(text, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = CharsBacker.splitToArray(text, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (int i = 1; i < split.length; ++i) {
                String fragment = split[i];
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefixAndSuffix) {
        return CharsBacker.subBetweenAll(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeat(c);
    }

    public static String repeat(CharSequence text, int count) {
        if (null == text) {
            return null;
        }
        return StringRepeater.of(count).repeat(text);
    }

    public static String repeatByLength(CharSequence text, int padLen) {
        if (null == text) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        return StringRepeater.of(padLen).repeatByLength(text);
    }

    public static String repeatAndJoin(CharSequence text, int count, CharSequence delimiter) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeatAndJoin(text, delimiter);
    }

    public static boolean equals(CharSequence text1, CharSequence text2) {
        return CharsBacker.equals(text1, text2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence text1, CharSequence text2) {
        return CharsBacker.equals(text1, text2, true);
    }

    public static boolean equals(CharSequence text1, CharSequence text2, boolean ignoreCase) {
        if (null == text1) {
            return text2 == null;
        }
        if (null == text2) {
            return false;
        }
        if (ignoreCase) {
            return text1.toString().equalsIgnoreCase(text2.toString());
        }
        return text1.toString().contentEquals(text2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence text1, CharSequence ... strs) {
        return CharsBacker.equalsAny(text1, true, strs);
    }

    public static boolean equalsAny(CharSequence text1, CharSequence ... strs) {
        return CharsBacker.equalsAny(text1, false, strs);
    }

    public static boolean equalsAny(CharSequence text, boolean ignoreCase, CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence cs : args) {
            if (!CharsBacker.equals(text, cs, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsCharAt(CharSequence text, int position, char c) {
        if (null == text || position < 0) {
            return false;
        }
        return text.length() > position && c == text.charAt(position);
    }

    public static boolean isSubEquals(CharSequence text1, int offset1, CharSequence text2, boolean ignoreCase) {
        return CharsBacker.isSubEquals(text1, offset1, text2, 0, text2.length(), ignoreCase);
    }

    public static boolean isSubEquals(CharSequence text1, int offset1, CharSequence text2, int offset2, int length, boolean ignoreCase) {
        if (null == text1 || null == text2) {
            return false;
        }
        return text1.toString().regionMatches(ignoreCase, offset1, text2.toString(), offset2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        if (ArrayKit.isEmpty(params) || CharsBacker.isBlank(template)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String wrap(CharSequence text, CharSequence prefixAndSuffix) {
        return CharsBacker.wrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return CharsBacker.toStringOrEmpty(prefix).concat(CharsBacker.toStringOrEmpty(text)).concat(CharsBacker.toStringOrEmpty(suffix));
    }

    public static String wrap(CharSequence text, char prefix, char suffix) {
        return prefix + CharsBacker.toStringOrEmpty(text) + suffix;
    }

    public static String[] wrapAllWithPair(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharsBacker.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharsBacker.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence text, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (CharsBacker.isNotEmpty(text)) {
            len += text.length();
        }
        if (CharsBacker.isNotEmpty(prefix)) {
            len += prefix.length();
        }
        if (CharsBacker.isNotEmpty(suffix)) {
            len += suffix.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (CharsBacker.isNotEmpty(prefix) && !CharsBacker.startWith(text, prefix)) {
            sb.append(prefix);
        }
        if (CharsBacker.isNotEmpty(text)) {
            sb.append(text);
        }
        if (CharsBacker.isNotEmpty(suffix) && !CharsBacker.endWith(text, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllWithPairIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharsBacker.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharsBacker.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence text, String prefix, String suffix) {
        if (CharsBacker.isWrap(text, prefix, suffix)) {
            return CharsBacker.sub(text, prefix.length(), text.length() - suffix.length());
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefix, char suffix) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        if (CharsBacker.isWrap(text, prefix, suffix)) {
            return CharsBacker.sub(text, 1, text.length() - 1);
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefixAndSuffix) {
        return CharsBacker.unWrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (ArrayKit.hasNull(text, prefix, suffix)) {
            return false;
        }
        if (text.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String text2 = text.toString();
        return text2.startsWith(prefix.toString()) && text2.endsWith(suffix.toString());
    }

    public static boolean isWrap(CharSequence text, String wrapper) {
        return CharsBacker.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char wrapper) {
        return CharsBacker.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char prefixChar, char suffixChar) {
        if (null == text || text.length() < 2) {
            return false;
        }
        return text.charAt(0) == prefixChar && text.charAt(text.length() - 1) == suffixChar;
    }

    public static String left(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(0, len);
    }

    public static String right(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(text.length() - len);
    }

    public static String mid(String text, int pos, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0 || pos > text.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (text.length() <= pos + len) {
            return text.substring(pos);
        }
        return text.substring(pos, pos + len);
    }

    public static String padPre(CharSequence text, int length, CharSequence padStr) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == length) {
            return text.toString();
        }
        if (strLen > length) {
            return CharsBacker.subPre(text, length);
        }
        return CharsBacker.repeatByLength(padStr, length - strLen).concat(text.toString());
    }

    public static String padPre(CharSequence text, int length, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == length) {
            return text.toString();
        }
        if (strLen > length) {
            return CharsBacker.subPre(text, length);
        }
        return CharsBacker.repeat(padChar, length - strLen).concat(text.toString());
    }

    public static String padAfter(CharSequence text, int length, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == length) {
            return text.toString();
        }
        if (strLen > length) {
            return CharsBacker.sub(text, strLen - length, strLen);
        }
        return text.toString().concat(CharsBacker.repeat(padChar, length - strLen));
    }

    public static String padAfter(CharSequence text, int length, CharSequence padStr) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == length) {
            return text.toString();
        }
        if (strLen > length) {
            return CharsBacker.subSufByLength(text, length);
        }
        return text.toString().concat(CharsBacker.repeatByLength(padStr, length - strLen));
    }

    public static String center(CharSequence text, int size) {
        return CharsBacker.center(text, size, ' ');
    }

    public static String center(CharSequence text, int size, char padChar) {
        if (text == null || size <= 0) {
            return CharsBacker.toStringOrNull(text);
        }
        int strLen = text.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return text.toString();
        }
        text = CharsBacker.padPre(text, strLen + pads / 2, padChar);
        text = CharsBacker.padAfter(text, size, padChar);
        return text.toString();
    }

    public static String center(CharSequence text, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (text == null || size <= 0) {
            return CharsBacker.toStringOrNull(text);
        }
        if (CharsBacker.isEmpty(padStr)) {
            padStr = " ";
        }
        if ((pads = size - (strLen = text.length())) <= 0) {
            return text.toString();
        }
        text = CharsBacker.padPre(text, strLen + pads / 2, padStr);
        text = CharsBacker.padAfter(text, size, padStr);
        return text.toString();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharsBacker.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharsBacker.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static int compare(CharSequence text1, CharSequence text2, boolean nullIsLess) {
        if (text1 == text2) {
            return 0;
        }
        if (text1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (text2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return text1.toString().compareTo(text2.toString());
    }

    public static int compareIgnoreCase(CharSequence text1, CharSequence text2, boolean nullIsLess) {
        if (text1 == text2) {
            return 0;
        }
        if (text1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (text2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return text1.toString().compareToIgnoreCase(text2.toString());
    }

    public static int compareVersion(CharSequence version1, CharSequence version2) {
        return VersionCompare.INSTANCE.compare(CharsBacker.toStringOrNull(version1), CharsBacker.toStringOrNull(version2));
    }

    public static String appendIfMissing(CharSequence text, CharSequence suffix, CharSequence ... suffixes) {
        return CharsBacker.appendIfMissing(text, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence text, CharSequence suffix, CharSequence ... suffixes) {
        return CharsBacker.appendIfMissing(text, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence text, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (text == null || CharsBacker.isEmpty(suffix) || CharsBacker.endWith(text, suffix, ignoreCase)) {
            return CharsBacker.toStringOrNull(text);
        }
        if (ArrayKit.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharsBacker.endWith(text, testSuffix, ignoreCase)) continue;
                return text.toString();
            }
        }
        return text.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence text, CharSequence prefix, CharSequence ... prefixes) {
        return CharsBacker.prependIfMissing(text, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence text, CharSequence prefix, CharSequence ... prefixes) {
        return CharsBacker.prependIfMissing(text, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence text, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (text == null || CharsBacker.isEmpty(prefix) || CharsBacker.startWith(text, prefix, ignoreCase)) {
            return CharsBacker.toStringOrNull(text);
        }
        if (ArrayKit.isNotEmpty(prefixes)) {
            for (CharSequence s : prefixes) {
                if (!CharsBacker.startWith(text, s, ignoreCase)) continue;
                return text.toString();
            }
        }
        return prefix.toString().concat(text.toString());
    }

    public static String replaceFirst(CharSequence text, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int startInclude = CharsBacker.indexOf(text, searchStr, 0, ignoreCase);
        if (-1 == startInclude) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.replaceByCodePoint(text, startInclude, startInclude + searchStr.length(), replacedStr);
    }

    public static String replaceLast(CharSequence text, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int lastIndex = CharsBacker.lastIndexOf(text, searchStr, text.length(), ignoreCase);
        if (-1 == lastIndex) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.replace(text, lastIndex, searchStr, replacedStr, ignoreCase);
    }

    public static String replaceIgnoreCase(CharSequence text, CharSequence searchStr, CharSequence replacement) {
        return CharsBacker.replace(text, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence text, CharSequence searchStr, CharSequence replacement) {
        return CharsBacker.replace(text, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence text, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return CharsBacker.replace(text, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence text, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(searchStr)) {
            return CharsBacker.toStringOrNull(text);
        }
        return new SearchReplacer(fromIndex, searchStr, replacement, ignoreCase).apply(text);
    }

    public static String replaceByCodePoint(CharSequence text, int beginInclude, int endExclude, char replacedChar) {
        return new CharRangeReplacer(beginInclude, endExclude, replacedChar, true).apply(text);
    }

    public static String replaceByCodePoint(CharSequence text, int beginInclude, int endExclude, CharSequence replacedStr) {
        return new StringRangeReplacer(beginInclude, endExclude, replacedStr, true).apply(text);
    }

    public static String replace(CharSequence text, java.util.regex.Pattern pattern, FunctionX<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, pattern, replaceFun);
    }

    public static String replace(CharSequence text, String regex, FunctionX<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, regex, replaceFun);
    }

    public static String hide(CharSequence text, int startInclude, int endExclude) {
        return CharsBacker.replaceByCodePoint(text, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence text, String chars, CharSequence replacedStr) {
        if (CharsBacker.isEmpty(text) || CharsBacker.isEmpty(chars)) {
            return CharsBacker.toStringOrNull(text);
        }
        return CharsBacker.replaceChars(text, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence text, char[] chars, CharSequence replacedStr) {
        if (CharsBacker.isEmpty(text) || ArrayKit.isEmpty(chars)) {
            return CharsBacker.toStringOrNull(text);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = text.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = text.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String replaceAt(CharSequence text, int index, UnaryOperator<Character> operator) {
        Character newC;
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (index < 0) {
            index += length;
        }
        String string = text.toString();
        if (index < 0 || index >= length) {
            return string;
        }
        char c = string.charAt(index);
        if (c == (newC = (Character)operator.apply(Character.valueOf(c))).charValue()) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[index] = newC.charValue();
        return new String(chars);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int codeLength(CharSequence cs) {
        return cs == null ? 0 : cs.toString().codePointCount(0, cs.length());
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static int totalLength(CharSequence ... args) {
        int totalLength = 0;
        for (CharSequence text : args) {
            totalLength += CharsBacker.length(text);
        }
        return totalLength;
    }

    public static String limitLength(CharSequence text, int length) {
        Assert.isTrue(length > 0);
        if (null == text) {
            return null;
        }
        if (text.length() <= length) {
            return text.toString();
        }
        return CharsBacker.sub(text, 0, length) + "...";
    }

    public static String limitByteLengthUtf8(CharSequence text, int maxBytesLength, boolean appendDots) {
        return CharsBacker.limitByteLength(text, org.miaixz.bus.core.lang.Charset.UTF_8, maxBytesLength, 4, appendDots);
    }

    public static String limitByteLength(CharSequence text, Charset charset, int maxBytesLength, int factor, boolean appendDots) {
        if (text == null || text.length() * factor <= maxBytesLength) {
            return CharsBacker.toStringOrNull(text);
        }
        byte[] sba = ByteKit.toBytes(text, charset);
        if (sba.length <= maxBytesLength) {
            return CharsBacker.toStringOrNull(text);
        }
        int limitBytes = appendDots ? maxBytesLength - "...".getBytes(charset).length : maxBytesLength;
        ByteBuffer bb = ByteBuffer.wrap(sba, 0, limitBytes);
        CharBuffer cb = CharBuffer.allocate(limitBytes);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.decode(bb, cb, true);
        decoder.flush(cb);
        String result = new String(cb.array(), 0, cb.position());
        if (appendDots) {
            return result + "...";
        }
        return result;
    }

    public static <T extends CharSequence> T firstNonNull(T ... args) {
        return (T)((CharSequence)ArrayKit.firstNonNull(args));
    }

    public static <T extends CharSequence> T firstNonEmpty(T ... args) {
        return (T)ArrayKit.firstMatch(CharsValidator::isNotEmpty, args);
    }

    public static <T extends CharSequence> T firstNonBlank(T ... args) {
        return (T)ArrayKit.firstMatch(CharsValidator::isNotBlank, args);
    }

    public static String toLowerCase(CharSequence text) {
        return CharsBacker.toLowerCase(text, Locale.getDefault());
    }

    public static String toLowerCase(CharSequence text, Locale locale) {
        if (null == text) {
            return null;
        }
        if (0 == text.length()) {
            return "";
        }
        return text.toString().toLowerCase(locale);
    }

    public static String toUpperCase(CharSequence text) {
        return CharsBacker.toUpperCase(text, Locale.getDefault());
    }

    public static String toUpperCase(CharSequence text, Locale locale) {
        if (null == text) {
            return null;
        }
        if (0 == text.length()) {
            return "";
        }
        return text.toString().toUpperCase();
    }

    public static String upperFirstAndAddPre(CharSequence text, String preString) {
        if (text == null || preString == null) {
            return null;
        }
        return preString + CharsBacker.upperFirst(text);
    }

    public static String upperFirst(CharSequence text) {
        return CharsBacker.upperAt(text, 0);
    }

    public static String upperAt(CharSequence text, int index) {
        return CharsBacker.replaceAt(text, index, Character::toUpperCase);
    }

    public static String lowerFirst(CharSequence text) {
        return CharsBacker.lowerAt(text, 0);
    }

    public static String lowerAt(CharSequence text, int index) {
        return CharsBacker.replaceAt(text, index, Character::toLowerCase);
    }

    public static String filter(CharSequence text, Predicate<Character> predicate) {
        if (text == null || predicate == null) {
            return CharsBacker.toStringOrNull(text);
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (!predicate.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence text) {
        return NamingCase.isUpperCase(text);
    }

    public static boolean isLowerCase(CharSequence text) {
        return NamingCase.isLowerCase(text);
    }

    public static String swapCase(String text) {
        return NamingCase.swapCase(text);
    }

    public static String toUnderlineCase(CharSequence text) {
        return NamingCase.toUnderlineCase(text);
    }

    public static String toSymbolCase(CharSequence text, char symbol) {
        return NamingCase.toSymbolCase(text, symbol);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        return NamingCase.toCamelCase(name, symbol);
    }

    public static StringBuilder builder(CharSequence text) {
        return text instanceof StringBuilder ? (StringBuilder)text : new StringBuilder(text);
    }

    public static StringBuilder builder(CharSequence ... args) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence text : args) {
            sb.append(text);
        }
        return sb;
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return CharsBacker.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (getOrSetMethodNameStr.startsWith("is")) {
            return CharsBacker.removePreAndLowerFirst(getOrSetMethodName, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return CharsBacker.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return CharsBacker.upperFirstAndAddPre(fieldName, "get");
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... args) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence text : args) {
            sb.append(isNullToEmpty ? CharsBacker.toStringOrEmpty(text) : text);
        }
        return sb.toString();
    }

    public static String brief(CharSequence text, int maxLength) {
        if (null == text) {
            return null;
        }
        int strLength = text.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return text.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(text.charAt(0));
            }
            case 2: {
                return text.charAt(0) + ".";
            }
            case 3: {
                return text.charAt(0) + "." + text.charAt(strLength - 1);
            }
            case 4: {
                return text.charAt(0) + ".." + text.charAt(strLength - 1);
            }
        }
        int suffixLength = (maxLength - 3) / 2;
        int preLength = suffixLength + (maxLength - 3) % 2;
        String text2 = text.toString();
        return CharsBacker.format("{}...{}", text2.substring(0, preLength), text2.substring(strLength - suffixLength));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayKit.join(objs, conjunction);
    }

    public static <T> String join(CharSequence conjunction, Iterable<T> iterable) {
        return CollKit.join(iterable, conjunction);
    }

    public static boolean isNumeric(CharSequence text) {
        return CharsBacker.isAllCharMatch(text, Character::isDigit);
    }

    public static String move(CharSequence text, int startInclude, int endExclude, int moveLength) {
        if (CharsBacker.isEmpty(text)) {
            return CharsBacker.toStringOrNull(text);
        }
        int len = text.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StringBuilder strBuilder = new StringBuilder(len);
        if (moveLength > 0) {
            int endAfterMove = Math.min(endExclude + moveLength, text.length());
            strBuilder.append(text.subSequence(0, startInclude)).append(text.subSequence(endExclude, endAfterMove)).append(text.subSequence(startInclude, endExclude)).append(text.subSequence(endAfterMove, text.length()));
        } else if (moveLength < 0) {
            int startAfterMove = Math.max(startInclude + moveLength, 0);
            strBuilder.append(text.subSequence(0, startAfterMove)).append(text.subSequence(startInclude, endExclude)).append(text.subSequence(startAfterMove, startInclude)).append(text.subSequence(endExclude, text.length()));
        } else {
            return CharsBacker.toStringOrNull(text);
        }
        return strBuilder.toString();
    }

    public static boolean isCharEquals(CharSequence text) {
        Assert.notEmpty(text, "Text to check must be not empty!", new Object[0]);
        return CharsBacker.count(text, text.charAt(0)) == text.length();
    }

    public static String normalize(CharSequence text) {
        return Normalizer.normalize(text, Normalizer.Form.NFC);
    }

    public static String fixLength(CharSequence text, char fixedChar, int length) {
        int fixedLength = length - text.length();
        if (fixedLength <= 0) {
            return text.toString();
        }
        return String.valueOf(text) + CharsBacker.repeat(fixedChar, fixedLength);
    }

    public static CharSequence commonPrefix(CharSequence text1, CharSequence text2) {
        int index;
        if (CharsBacker.isEmpty(text1) || CharsBacker.isEmpty(text2)) {
            return "";
        }
        int minLength = Math.min(text1.length(), text2.length());
        for (index = 0; index < minLength && text1.charAt(index) == text2.charAt(index); ++index) {
        }
        return text1.subSequence(0, index);
    }

    public static CharSequence commonSuffix(CharSequence text1, CharSequence text2) {
        if (CharsBacker.isEmpty(text1) || CharsBacker.isEmpty(text2)) {
            return "";
        }
        int str1Index = text1.length() - 1;
        for (int str2Index = text2.length() - 1; str1Index >= 0 && str2Index >= 0 && text1.charAt(str1Index) == text2.charAt(str2Index); --str1Index, --str2Index) {
        }
        return text1.subSequence(str1Index + 1, text1.length());
    }

    public static <T> T splitTo(CharSequence text, CharSequence separator, Class<T> resultType) {
        return Convert.convert(resultType, CharsBacker.splitTrim(text, separator));
    }

    public static List<String> splitTrim(CharSequence text, CharSequence separator) {
        return CharsBacker.split(text, separator, true, true);
    }

    public static String[] splitToArray(CharSequence text, CharSequence separator) {
        if (text == null) {
            return new String[0];
        }
        return CharsBacker.split(text, separator).toArray(new String[0]);
    }

    public static String split(String text) {
        return CharsBacker.split(text, ",", ",");
    }

    public static String split(String text, String separator, String reserve) {
        StringBuffer sb = new StringBuffer();
        if (CharsBacker.isNotEmpty(text)) {
            String[] arr = CharsBacker.splitToArray(text, separator);
            for (int i = 0; i < arr.length; ++i) {
                if (i == 0) {
                    sb.append("'").append(arr[i]).append("'");
                    continue;
                }
                sb.append(reserve).append("'").append(arr[i]).append("'");
            }
        }
        return sb.toString();
    }

    public static List<String> split(CharSequence text, CharSequence separator) {
        return CharsBacker.split(text, separator, false, false);
    }

    public static List<String> split(CharSequence text, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return CharsBacker.split(text, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return CharsBacker.split(text, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return CharsBacker.split(text, separator, limit, ignoreEmpty, ignoreCase, CharsBacker.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence text, CharSequence separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == text) {
            return ListKit.zero();
        }
        if (0 == text.length() && ignoreEmpty) {
            return ListKit.zero();
        }
        Assert.notEmpty(separator, "Separator must be not empty!", new Object[0]);
        TextFinder finder = separator.length() == 1 ? new CharFinder(separator.charAt(0), ignoreCase) : StringFinder.of(separator, ignoreCase);
        StringSplitter stringSplitter = new StringSplitter(text, finder, limit, ignoreEmpty);
        return stringSplitter.toList(mapping);
    }

    public static List<String> splitPath(CharSequence text) {
        return CharsBacker.splitPath(text, -1);
    }

    public static List<String> splitPath(CharSequence text, int limit) {
        if (CharsBacker.isBlank(text)) {
            return ListKit.zero();
        }
        StringSplitter stringSplitter = new StringSplitter(text, new MatcherFinder(c -> c.charValue() == '/' || c.charValue() == '\\'), limit, true);
        return stringSplitter.toList(false);
    }

    public static List<String> splitByBlank(CharSequence text) {
        return CharsBacker.splitByBlank(text, -1);
    }

    public static List<String> splitByBlank(CharSequence text, int limit) {
        if (CharsBacker.isBlank(text)) {
            return ListKit.zero();
        }
        StringSplitter stringSplitter = new StringSplitter(text, new MatcherFinder(CharKit::isBlankChar), limit, true);
        return stringSplitter.toList(false);
    }

    public static String[] splitByBlankToArray(CharSequence text, int limit) {
        return CharsBacker.splitByBlank(text, limit).toArray(new String[0]);
    }

    public static List<String> splitByRegex(CharSequence text, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        return CharsBacker.splitByRegex(text, CharsBacker.isEmpty(text) || CharsBacker.isEmpty(separatorRegex) ? null : Pattern.get(separatorRegex), limit, isTrim, ignoreEmpty);
    }

    public static List<String> splitByRegex(CharSequence text, java.util.regex.Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == text) {
            return ListKit.zero();
        }
        if (0 == text.length()) {
            return ignoreEmpty ? ListKit.zero() : ListKit.of("");
        }
        if (null == separatorPattern) {
            String result = text.toString();
            if (CharsBacker.isEmpty(result)) {
                return ignoreEmpty ? ListKit.zero() : ListKit.of("");
            }
            return ListKit.of(result);
        }
        StringSplitter stringSplitter = new StringSplitter(text, new PatternFinder(separatorPattern), limit, ignoreEmpty);
        return stringSplitter.toList(isTrim);
    }

    public static String[] splitByRegexToArray(CharSequence text, java.util.regex.Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return CharsBacker.splitByRegex(text, separatorPattern, limit, isTrim, ignoreEmpty).toArray(new String[0]);
    }

    public static String[] splitByLength(CharSequence text, int len) {
        if (CharsBacker.isEmpty(text)) {
            return new String[0];
        }
        StringSplitter stringSplitter = new StringSplitter(text, new LengthFinder(len), -1, false);
        return stringSplitter.toArray(false);
    }

    public static Function<String, String> trimFunc(boolean isTrim) {
        return isTrim ? CharsBacker::trim : Function.identity();
    }

    public static int[] toChars(CharSequence text, boolean isCodePoint) {
        if (null == text) {
            return null;
        }
        return (isCodePoint ? text.codePoints() : text.chars()).toArray();
    }

    public static void forEach(CharSequence str, Consumer<Character> consumer) {
        CharsBacker.forEach(str, false, cInt -> consumer.accept(Character.valueOf((char)cInt)));
    }

    public static void forEach(CharSequence str, boolean isCodePoint, IntConsumer consumer) {
        if (null == str) {
            return;
        }
        (isCodePoint ? str.codePoints() : str.chars()).forEach(consumer);
    }

    public static String formatByMap(CharSequence template, Map<?, ?> map) {
        return CharsBacker.formatByMap(template, map, true);
    }

    public static String formatByMap(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        return StringFormatter.formatByBean(template, map, ignoreNull);
    }

    public static String formatByBean(CharSequence template, Object bean, boolean ignoreNull) {
        return StringFormatter.formatByBean(template, bean, ignoreNull);
    }
}

