/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.dfa;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.text.dfa.FoundWord;
import org.miaixz.bus.core.text.dfa.SensitiveProcessor;
import org.miaixz.bus.core.text.dfa.WordTree;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ThreadKit;

public class Sensitive {
    public static final String DEFAULT_SEPARATOR = ",";
    private static final WordTree sensitiveTree = new WordTree();

    public static boolean isInitialized() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadKit.execAsync(() -> {
                Sensitive.init(sensitiveWords);
                return true;
            });
        } else {
            Sensitive.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, String separator, boolean isAsync) {
        if (StringKit.isNotBlank(sensitiveWords)) {
            Sensitive.init(CharsBacker.split(sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        Sensitive.init(sensitiveWords, DEFAULT_SEPARATOR, isAsync);
    }

    public static void setCharFilter(Predicate<Character> charFilter) {
        if (charFilter != null) {
            sensitiveTree.setCharFilter(charFilter);
        }
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        return sensitiveTree.matchWord(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        return sensitiveTree.matchAllWords(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    public static String sensitiveFilter(String text) {
        return Sensitive.sensitiveFilter(text, true, null);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = Sensitive.getFoundAllSensitive(text, true, isGreedMatch);
        if (CollKit.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size(), 1.0f);
        foundWordList.forEach(foundWord -> foundWordMap.put((Integer)foundWord.getBeginIndex(), foundWord));
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            FoundWord fw = (FoundWord)foundWordMap.get(i);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i));
        }
        return textStringBuilder.toString();
    }
}

