/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.placeholder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.text.placeholder.segment.AbstractSegment;
import org.miaixz.bus.core.text.placeholder.segment.LiteralSegment;
import org.miaixz.bus.core.text.placeholder.segment.StringSegment;
import org.miaixz.bus.core.text.placeholder.template.NamedPlaceholderString;
import org.miaixz.bus.core.text.placeholder.template.SinglePlaceholderString;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StringKit;

public abstract class StringTemplate {
    protected static int globalFeatures = Feature.of(Feature.FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER, Feature.FORMAT_NULL_VALUE_TO_STR, Feature.MATCH_KEEP_DEFAULT_VALUE, Feature.MATCH_EMPTY_VALUE_TO_NULL, Feature.MATCH_NULL_STR_TO_NULL);
    protected static UnaryOperator<String> globalDefaultValueHandler;
    protected final char escape;
    protected final String defaultValue;
    protected final UnaryOperator<String> defaultValueHandler;
    private final String template;
    private final int features;
    protected List<StringSegment> segments;
    protected List<AbstractSegment> placeholderSegments;
    protected int fixedTextTotalLength;

    protected StringTemplate(String template, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler, int features) {
        Assert.notNull(template, "String template cannot be null", new Object[0]);
        this.template = template;
        this.escape = escape;
        this.defaultValue = defaultValue;
        this.defaultValueHandler = defaultValueHandler;
        this.features = features;
    }

    public static SinglePlaceholderString.Builder of(String template) {
        return SinglePlaceholderString.builder(template);
    }

    public static NamedPlaceholderString.Builder ofNamed(String template) {
        return NamedPlaceholderString.builder(template);
    }

    public static void setGlobalFeatures(Feature ... globalFeatures) {
        StringTemplate.globalFeatures = Feature.of(globalFeatures);
    }

    public static void setGlobalDefaultValue(UnaryOperator<String> globalDefaultValueHandler) {
        StringTemplate.globalDefaultValueHandler = Objects.requireNonNull(globalDefaultValueHandler);
    }

    public String getTemplate() {
        return this.template;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isMatches(String text) {
        if (StringKit.isEmpty(text)) {
            return false;
        }
        int startIdx = 0;
        boolean hasPlaceholder = false;
        for (StringSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                String newText = segment.getText();
                int findIdx = text.indexOf(newText, startIdx);
                if (findIdx == -1) {
                    return false;
                }
                if (findIdx != startIdx && !hasPlaceholder) {
                    return false;
                }
                startIdx = findIdx + newText.length();
                hasPlaceholder = false;
                continue;
            }
            if (hasPlaceholder) {
                throw new InternalException("There are two closely related placeholders that cannot be split properly!");
            }
            hasPlaceholder = true;
        }
        return true;
    }

    public List<String> getPlaceholderVariableNames() {
        return this.placeholderSegments.stream().map(AbstractSegment::getPlaceholder).collect(Collectors.toList());
    }

    public List<String> getPlaceholderTexts() {
        return this.placeholderSegments.stream().map(AbstractSegment::getText).collect(Collectors.toList());
    }

    public String formatRawByKey(Function<String, String> valueSupplier) {
        return this.formatRawBySegment(segment -> (String)valueSupplier.apply(segment.getPlaceholder()));
    }

    public String formatRawBySegment(Function<AbstractSegment, String> valueSupplier) {
        ArrayList<String> list = new ArrayList<String>(this.placeholderSegments.size());
        int totalTextLength = this.fixedTextTotalLength;
        for (AbstractSegment segment : this.placeholderSegments) {
            String values = valueSupplier.apply(segment);
            if (values == null) {
                values = "null";
            }
            totalTextLength += values.length();
            list.add(values);
        }
        StringBuilder sb = new StringBuilder(totalTextLength);
        int index = 0;
        for (StringSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                sb.append(segment.getText());
                continue;
            }
            sb.append((String)list.get(index++));
        }
        return sb.toString();
    }

    protected String formatSequence(Iterable<?> iterable) {
        if (iterable == null) {
            return this.getTemplate();
        }
        Iterator<?> iterator = iterable.iterator();
        return this.formatBySegment(segment -> {
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return this.formatMissingKey((AbstractSegment)segment);
        });
    }

    protected String formatBySegment(Function<AbstractSegment, ?> valueSupplier) {
        return this.formatRawBySegment(segment -> {
            Object value = valueSupplier.apply((AbstractSegment)segment);
            if (value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                return StringKit.toString(value);
            }
            return this.formatNullValue((AbstractSegment)segment);
        });
    }

    protected String formatMissingKey(AbstractSegment segment) {
        int features = this.getFeatures();
        if (Feature.FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER.contains(features)) {
            return segment.getText();
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_DEFAULT_VALUE.contains(features)) {
            return this.getDefaultValue(segment);
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_NULL.contains(features)) {
            return "null";
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_EMPTY.contains(features)) {
            return "";
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_VARIABLE_NAME.contains(features)) {
            return segment.getPlaceholder();
        }
        if (Feature.FORMAT_MISSING_KEY_THROWS.contains(features)) {
            throw new InternalException("There is no value associated with data: '" + segment.getPlaceholder() + "'");
        }
        throw new InternalException("There is no value associated with data: '" + segment.getPlaceholder() + "'. You should define some Feature for missing data when building.");
    }

    protected String formatNullValue(AbstractSegment segment) {
        int features = this.getFeatures();
        if (Feature.FORMAT_NULL_VALUE_TO_STR.contains(features)) {
            return "null";
        }
        if (Feature.FORMAT_NULL_VALUE_TO_EMPTY.contains(features)) {
            return "";
        }
        if (Feature.FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER.contains(features)) {
            return segment.getText();
        }
        if (Feature.FORMAT_NULL_VALUE_TO_DEFAULT_VALUE.contains(features)) {
            return this.getDefaultValue(segment);
        }
        throw new InternalException("There is a NULL value cannot resolve. You should define a Feature for null value when building or filter null value.");
    }

    public void matchesRawByKey(String text, BiConsumer<String, String> keyValueConsumer) {
        if (text == null || keyValueConsumer == null || CollKit.isEmpty(this.placeholderSegments)) {
            return;
        }
        this.matchesRawBySegment(text, (segment, value) -> keyValueConsumer.accept(segment.getPlaceholder(), (String)value));
    }

    public void matchesRawBySegment(String text, BiConsumer<AbstractSegment, String> keyValueConsumer) {
        if (text == null || keyValueConsumer == null || CollKit.isEmpty(this.placeholderSegments)) {
            return;
        }
        int startIdx = 0;
        AbstractSegment placeholderSegment = null;
        for (StringSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                String newText = segment.getText();
                int findIdx = text.indexOf(newText, startIdx);
                if (findIdx == -1) {
                    return;
                }
                if (placeholderSegment != null) {
                    keyValueConsumer.accept(placeholderSegment, text.substring(startIdx, findIdx));
                } else if (findIdx != startIdx) {
                    return;
                }
                startIdx = findIdx + newText.length();
                placeholderSegment = null;
                continue;
            }
            if (placeholderSegment != null) {
                throw new InternalException("There are two closely related placeholders that cannot be split properly!");
            }
            placeholderSegment = (AbstractSegment)segment;
        }
        if (placeholderSegment != null) {
            keyValueConsumer.accept(placeholderSegment, text.substring(startIdx));
        }
    }

    protected List<String> matchesSequence(String text) {
        if (text == null || this.placeholderSegments.isEmpty() || !this.isMatches(text)) {
            return ListKit.zero();
        }
        ArrayList<String> list = new ArrayList<String>(this.placeholderSegments.size());
        this.matchesByKey(text, (segment, value) -> list.add((String)value));
        return list;
    }

    public void matchesByKey(String text, BiConsumer<String, String> keyValueConsumer) {
        if (this.hasDefaultValue()) {
            this.matchesByKey(text, keyValueConsumer, true, this::getDefaultValue);
        } else {
            this.matchesByKey(text, keyValueConsumer, false, null);
        }
    }

    protected void matchesByKey(String text, BiConsumer<String, String> keyValueConsumer, boolean hasDefaultValue, Function<AbstractSegment, String> defaultValueSupplier) {
        if (text == null || keyValueConsumer == null || CollKit.isEmpty(this.placeholderSegments)) {
            return;
        }
        this.matchesRawBySegment(text, (segment, value) -> this.matchByKey(keyValueConsumer, segment.getPlaceholder(), (String)value, hasDefaultValue, () -> hasDefaultValue ? StringKit.toString(defaultValueSupplier.apply((AbstractSegment)segment)) : null));
    }

    private void matchByKey(BiConsumer<String, String> keyValueConsumer, String key, String value, boolean hasDefaultValue, Supplier<String> defaultValueSupplier) {
        int features = this.getFeatures();
        if (hasDefaultValue && !Feature.MATCH_KEEP_DEFAULT_VALUE.contains(features) && value.equals(defaultValueSupplier.get())) {
            if (Feature.MATCH_IGNORE_DEFAULT_VALUE.contains(features)) {
                return;
            }
            if (Feature.MATCH_DEFAULT_VALUE_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
                return;
            }
        }
        if ("".equals(value)) {
            if (Feature.MATCH_EMPTY_VALUE_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
            } else if (Feature.MATCH_EMPTY_VALUE_TO_DEFAULT_VALUE.contains(features)) {
                keyValueConsumer.accept(key, defaultValueSupplier.get());
            } else {
                if (Feature.MATCH_IGNORE_EMPTY_VALUE.contains(features)) {
                    return;
                }
                if (Feature.MATCH_KEEP_VALUE_EMPTY.contains(features)) {
                    keyValueConsumer.accept(key, value);
                }
            }
            return;
        }
        if ("null".equals(value)) {
            if (Feature.MATCH_NULL_STR_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
            } else if (Feature.MATCH_KEEP_NULL_STR.contains(features)) {
                keyValueConsumer.accept(key, value);
            } else if (Feature.MATCH_IGNORE_NULL_STR.contains(features)) {
                return;
            }
            return;
        }
        keyValueConsumer.accept(key, value);
    }

    protected boolean hasDefaultValue() {
        return this.defaultValue != null || this.defaultValueHandler != null || globalDefaultValueHandler != null;
    }

    protected String getDefaultValue(AbstractSegment segment) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.defaultValueHandler != null) {
            return StringKit.toString(this.defaultValueHandler.apply(segment.getPlaceholder()));
        }
        if (globalDefaultValueHandler != null) {
            return StringKit.toString(globalDefaultValueHandler.apply(segment.getPlaceholder()));
        }
        throw new InternalException("There is no default value for data: '" + segment.getPlaceholder() + "'. You should define a 'defaultValue' or 'defaultValueHandler' or 'globalDefaultValueHandler' when building.");
    }

    protected void afterInit() {
        this.segments = new ArrayList<StringSegment>(this.parseSegments(this.template));
        int literalSegmentSize = 0;
        int fixedTextTotalLength = 0;
        for (StringSegment segment : this.segments) {
            if (!(segment instanceof LiteralSegment)) continue;
            ++literalSegmentSize;
            fixedTextTotalLength += segment.getText().length();
        }
        this.fixedTextTotalLength = fixedTextTotalLength;
        int placeholderSegmentsSize = this.segments.size() - literalSegmentSize;
        if (placeholderSegmentsSize == 0) {
            this.placeholderSegments = Collections.emptyList();
        } else {
            ArrayList<AbstractSegment> placeholderSegments = new ArrayList<AbstractSegment>(placeholderSegmentsSize);
            for (StringSegment segment : this.segments) {
                if (!(segment instanceof AbstractSegment)) continue;
                placeholderSegments.add((AbstractSegment)segment);
            }
            this.placeholderSegments = placeholderSegments;
        }
    }

    protected void addLiteralSegment(boolean isLastLiteralSegment, List<StringSegment> list, String newText) {
        if (newText.isEmpty()) {
            return;
        }
        if (isLastLiteralSegment) {
            int lastIdx = list.size() - 1;
            StringSegment lastLiteralSegment = list.get(lastIdx);
            list.set(lastIdx, new LiteralSegment(lastLiteralSegment.getText() + newText));
        } else {
            list.add(new LiteralSegment(newText));
        }
    }

    protected abstract List<StringSegment> parseSegments(String var1);

    protected List<StringSegment> getSegments() {
        return this.segments;
    }

    protected List<AbstractSegment> getPlaceholderSegments() {
        return this.placeholderSegments;
    }

    public static enum Feature {
        FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER(0, 0, 6),
        FORMAT_MISSING_KEY_PRINT_DEFAULT_VALUE(1, 0, 6),
        FORMAT_MISSING_KEY_PRINT_NULL(2, 0, 6),
        FORMAT_MISSING_KEY_PRINT_EMPTY(3, 0, 6),
        FORMAT_MISSING_KEY_PRINT_VARIABLE_NAME(4, 0, 6),
        FORMAT_MISSING_KEY_THROWS(5, 0, 6),
        FORMAT_NULL_VALUE_TO_STR(6, 6, 4),
        FORMAT_NULL_VALUE_TO_EMPTY(7, 6, 4),
        FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER(8, 6, 4),
        FORMAT_NULL_VALUE_TO_DEFAULT_VALUE(9, 6, 4),
        MATCH_KEEP_DEFAULT_VALUE(16, 16, 3),
        MATCH_IGNORE_DEFAULT_VALUE(17, 16, 3),
        MATCH_DEFAULT_VALUE_TO_NULL(18, 16, 3),
        MATCH_EMPTY_VALUE_TO_NULL(19, 19, 4),
        MATCH_EMPTY_VALUE_TO_DEFAULT_VALUE(20, 19, 4),
        MATCH_IGNORE_EMPTY_VALUE(21, 19, 4),
        MATCH_KEEP_VALUE_EMPTY(22, 19, 4),
        MATCH_NULL_STR_TO_NULL(23, 23, 3),
        MATCH_KEEP_NULL_STR(24, 23, 3),
        MATCH_IGNORE_NULL_STR(25, 23, 3);

        private final int mask;
        private final int clearMask;

        private Feature(int bitPos, int bitStart, int bitLen) {
            this.mask = 1 << bitPos;
            this.clearMask = -1 << bitStart + bitLen | (1 << bitStart) - 1;
        }

        public static int of(Feature ... features) {
            if (features == null) {
                return 0;
            }
            int value = 0;
            for (Feature feature : features) {
                value = feature.set(value);
            }
            return value;
        }

        public boolean contains(int features) {
            return (features & this.mask) != 0;
        }

        public int set(int features) {
            return features & this.clearMask | this.mask;
        }

        public int clear(int features) {
            return features & this.clearMask;
        }
    }

    protected static abstract class AbstractBuilder<BuilderChild extends AbstractBuilder<BuilderChild, TemplateChild>, TemplateChild extends StringTemplate> {
        protected final String template;
        protected String defaultValue;
        protected UnaryOperator<String> defaultValueHandler;
        protected boolean escape$set;
        protected char escape;
        protected int features;

        protected AbstractBuilder(String template) {
            this.template = Objects.requireNonNull(template);
            this.features = globalFeatures;
        }

        public BuilderChild escape(char escape) {
            this.escape = escape;
            this.escape$set = true;
            return this.self();
        }

        public BuilderChild features(Feature ... newFeatures) {
            this.features = Feature.of(newFeatures);
            return this.self();
        }

        public BuilderChild addFeatures(Feature ... appendFeatures) {
            if (ArrayKit.isNotEmpty(appendFeatures)) {
                for (Feature feature : appendFeatures) {
                    this.features = feature.set(this.features);
                }
            }
            return this.self();
        }

        public BuilderChild removeFeatures(Feature ... removeFeatures) {
            if (ArrayKit.isNotEmpty(removeFeatures)) {
                for (Feature feature : removeFeatures) {
                    this.features = feature.clear(this.features);
                }
            }
            return this.self();
        }

        public BuilderChild defaultValue(String defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue);
            return this.self();
        }

        public BuilderChild defaultValue(UnaryOperator<String> defaultValueHandler) {
            this.defaultValueHandler = Objects.requireNonNull(defaultValueHandler);
            return this.self();
        }

        public TemplateChild build() {
            if (!this.escape$set) {
                this.escape = (char)92;
            }
            return this.buildInstance();
        }

        protected abstract BuilderChild self();

        protected abstract TemplateChild buildInstance();
    }
}

