/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import java.util.Map;
import org.miaixz.bus.core.text.finder.MultiStringFinder;
import org.miaixz.bus.core.text.replacer.HighMultiReplacer;
import org.miaixz.bus.core.text.replacer.StringReplacer;

public class HighMultiReplacerV2
extends StringReplacer {
    private static final long serialVersionUID = 2852238992618L;
    private final AhoCorasickAutomaton ahoCorasickAutomaton;

    public HighMultiReplacerV2(Map<String, Object> map) {
        this.ahoCorasickAutomaton = new AhoCorasickAutomaton(map);
    }

    public static HighMultiReplacer of(Map<String, Object> map) {
        return new HighMultiReplacer(map);
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        this.ahoCorasickAutomaton.replace(text, out);
        return text.length();
    }

    @Override
    public CharSequence apply(CharSequence text) {
        StringBuilder builder = new StringBuilder();
        this.replace(text, 0, builder);
        return builder;
    }

    protected static class AhoCorasickAutomaton
    extends MultiStringFinder {
        protected final Map<String, Object> replaceMap;

        public AhoCorasickAutomaton(Map<String, Object> replaceMap) {
            super(replaceMap.keySet());
            this.replaceMap = replaceMap;
        }

        public void replace(CharSequence text, StringBuilder stringBuilder) {
            MultiStringFinder.Node currentNode = this.root;
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                Integer index = (Integer)this.charIndexMap.get(Character.valueOf(ch));
                if (index == null || index < 0) {
                    if (temp.length() > 0) {
                        stringBuilder.append((CharSequence)temp);
                        temp.delete(0, temp.length());
                    }
                    stringBuilder.append(ch);
                    currentNode = this.root;
                    continue;
                }
                currentNode = currentNode.directRouter[index];
                if (currentNode.nodeIndex == 0 && temp.length() > 0) {
                    stringBuilder.append((CharSequence)temp);
                    temp.delete(0, temp.length());
                    stringBuilder.append(ch);
                    continue;
                }
                if (currentNode.isEnd) {
                    int length = currentNode.tagetString.length();
                    temp.delete(temp.length() - length + 1, length - 1);
                    if (temp.length() > 0) {
                        stringBuilder.append((CharSequence)temp);
                    }
                    stringBuilder.append(this.replaceMap.get(currentNode.tagetString));
                    currentNode = this.root;
                    continue;
                }
                temp.append(ch);
            }
        }
    }
}

