/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.miaixz.bus.core.lang.Chain;
import org.miaixz.bus.core.text.replacer.StringReplacer;

public class ReplacerChain
extends StringReplacer
implements Chain<StringReplacer, ReplacerChain> {
    private static final long serialVersionUID = 2852239321085L;
    private final List<StringReplacer> replacers = new LinkedList<StringReplacer>();

    public ReplacerChain(StringReplacer ... stringReplacers) {
        for (StringReplacer stringReplacer : stringReplacers) {
            this.addChain(stringReplacer);
        }
    }

    @Override
    public Iterator<StringReplacer> iterator() {
        return this.replacers.iterator();
    }

    @Override
    public ReplacerChain addChain(StringReplacer element) {
        this.replacers.add(element);
        return this;
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        int consumed = 0;
        for (StringReplacer stringReplacer : this.replacers) {
            consumed = stringReplacer.replace(text, pos, out);
            if (0 == consumed) continue;
            return consumed;
        }
        return consumed;
    }
}

