/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.tree;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.Builder;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.tree.MapTree;
import org.miaixz.bus.core.tree.NodeConfig;
import org.miaixz.bus.core.tree.parser.NodeParser;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class TreeBuilder<E>
implements Builder<MapTree<E>> {
    private static final long serialVersionUID = 2852250515557L;
    private final Map<E, MapTree<E>> idTreeMap;
    private boolean isBuild;
    private MapTree<E> root;

    public TreeBuilder(MapTree<E> root) {
        this.root = root;
        this.idTreeMap = new LinkedHashMap<E, MapTree<E>>();
    }

    public TreeBuilder(E rootId, NodeConfig config) {
        this((MapTree<E>)new MapTree(config).setId(rootId));
    }

    public static <T> TreeBuilder<T> of(T rootId) {
        return TreeBuilder.of(rootId, null);
    }

    public static <T> TreeBuilder<T> of(T rootId, NodeConfig config) {
        return new TreeBuilder<T>(rootId, config);
    }

    public TreeBuilder<E> setId(E id) {
        this.root.setId((Object)id);
        return this;
    }

    public TreeBuilder<E> setParentId(E parentId) {
        this.root.setParentId((Object)parentId);
        return this;
    }

    public TreeBuilder<E> setName(CharSequence name) {
        this.root.setName(name);
        return this;
    }

    public TreeBuilder<E> setWeight(Comparable<?> weight) {
        this.root.setWeight((Comparable)weight);
        return this;
    }

    public TreeBuilder<E> putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.root.put(key, value);
        return this;
    }

    public TreeBuilder<E> append(Map<E, MapTree<E>> map) {
        this.checkBuilt();
        this.idTreeMap.putAll(map);
        return this;
    }

    public TreeBuilder<E> append(Iterable<MapTree<E>> trees) {
        this.checkBuilt();
        if (null != trees) {
            this.append(trees.iterator());
        }
        return this;
    }

    public TreeBuilder<E> append(Iterator<MapTree<E>> iterator) {
        this.checkBuilt();
        while (iterator.hasNext()) {
            MapTree<E> tree = iterator.next();
            if (null == tree) continue;
            this.idTreeMap.put(tree.getId(), tree);
        }
        return this;
    }

    public <T> TreeBuilder<E> append(Iterable<T> list, final NodeParser<T, E> nodeParser) {
        this.checkBuilt();
        final NodeConfig config = this.root.getConfig();
        final Iterator<T> iterator = list.iterator();
        return this.append(new Iterator<MapTree<E>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public MapTree<E> next() {
                MapTree node = new MapTree(config);
                nodeParser.parse(iterator.next(), node);
                if (ObjectKit.equals(node.getId(), TreeBuilder.this.root.getId())) {
                    TreeBuilder.this.root = node;
                    return null;
                }
                return node;
            }
        });
    }

    public TreeBuilder<E> reset() {
        this.idTreeMap.clear();
        this.root.setChildren(null);
        this.isBuild = false;
        return this;
    }

    @Override
    public MapTree<E> build() {
        this.checkBuilt();
        this.buildFromMap();
        this.cutTree();
        this.isBuild = true;
        this.idTreeMap.clear();
        return this.root;
    }

    public List<MapTree<E>> buildList() {
        if (this.isBuild) {
            return this.root.getChildren();
        }
        return ((MapTree)this.build()).getChildren();
    }

    private void buildFromMap() {
        if (MapKit.isEmpty(this.idTreeMap)) {
            return;
        }
        Map<E, MapTree<E>> eTreeMap = MapKit.sortByValue(this.idTreeMap, false);
        for (MapTree<E> node : eTreeMap.values()) {
            if (null == node) continue;
            E parentId = node.getParentId();
            if (ObjectKit.equals(this.root.getId(), parentId)) {
                this.root.addChildren(node);
                continue;
            }
            MapTree<E> parentNode = eTreeMap.get(parentId);
            if (null == parentNode) continue;
            parentNode.addChildren(node);
        }
    }

    private void cutTree() {
        NodeConfig config = this.root.getConfig();
        Integer deep = config.getDeep();
        if (null == deep || deep < 0) {
            return;
        }
        this.cutTree(this.root, 0, deep);
    }

    private void cutTree(MapTree<E> tree, int currentDepp, int maxDeep) {
        if (null == tree) {
            return;
        }
        if (currentDepp == maxDeep) {
            tree.setChildren(null);
            return;
        }
        List<MapTree<E>> children = tree.getChildren();
        if (CollKit.isNotEmpty(children)) {
            for (MapTree<E> child : children) {
                this.cutTree(child, currentDepp + 1, maxDeep);
            }
        }
    }

    private void checkBuilt() {
        Assert.isFalse(this.isBuild, "Current tree has been built.", new Object[0]);
    }
}

