/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.array.ArrayWrapper;
import org.miaixz.bus.core.center.array.PrimitiveArray;
import org.miaixz.bus.core.center.set.UniqueKeySet;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.text.CharsValidator;
import org.miaixz.bus.core.text.StringJoiner;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ArrayKit
extends PrimitiveArray {
    public static <A> A castOrWrapSingle(Object values, Class<?> elementType) {
        if (ArrayKit.isArray(values)) {
            return (A)values;
        }
        return ArrayKit.wrapSingle(values, elementType);
    }

    public static <A> A wrapSingle(Object value, Class<?> elementType) {
        Object newInstance = Array.newInstance(null == elementType ? value.getClass() : elementType, 1);
        Array.set(newInstance, 0, value);
        return (A)newInstance;
    }

    public static <T> T[] ofArray(Iterable<T> iterable, Class<T> componentType) {
        if (null == iterable) {
            return ArrayKit.newArray(componentType, 0);
        }
        if (iterable instanceof List) {
            return ((List)iterable).toArray(ArrayKit.newArray(componentType, 0));
        }
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            T[] result = ArrayKit.newArray(componentType, size);
            int i = 0;
            for (T element : iterable) {
                result[i] = element;
                ++i;
            }
        }
        return ListKit.of(iterable.iterator()).toArray(ArrayKit.newArray(componentType, 0));
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : ArrayKit.getComponentType(array.getClass());
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayKit.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayKit.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayKit.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <A, T> A append(A array, T ... newElements) {
        if (ArrayKit.isEmpty(array)) {
            if (null == array) {
                return (A)newElements;
            }
            return (A)Convert.convert(array.getClass(), newElements);
        }
        return ArrayKit.insert(array, ArrayKit.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] array, int index, T value) {
        if (ArrayKit.isEmpty(array)) {
            return (Object[])ArrayKit.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrAppend(index, value).getRaw();
    }

    public static <A> A setOrAppend(A array, int index, Object value) {
        if (ArrayKit.isEmpty(array)) {
            return ArrayKit.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrAppend(index, value).getRaw();
    }

    public static <A> A setOrPadding(A array, int index, Object value) {
        if (index == 0 && ArrayKit.isEmpty(array)) {
            return ArrayKit.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrPadding(index, value).getRaw();
    }

    public static <A, E> A setOrPadding(A array, int index, E value, E paddingValue) {
        if (index == 0 && ArrayKit.isEmpty(array)) {
            return ArrayKit.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrPadding(index, value, paddingValue).getRaw();
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (!ArrayKit.isNotEmpty(array)) continue;
            length += array.length;
        }
        T[] result = ArrayKit.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        if (length == 0) {
            return result;
        }
        length = 0;
        for (T[] array : arrays) {
            if (!ArrayKit.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] replace(T[] array, int index, T ... values) {
        if (ArrayKit.isEmpty(array)) {
            return values;
        }
        return ArrayWrapper.of(array).replace(index, values).getRaw();
    }

    public static <A> A replace(A array, int index, A values) {
        if (ArrayKit.isEmpty(array)) {
            return ArrayKit.castOrWrapSingle(values, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).replace(index, values).getRaw();
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return ArrayKit.insert(buffer, index, newElements);
    }

    @SafeVarargs
    public static <A, E> A insert(A array, int index, E ... newElements) {
        return (A)ArrayWrapper.of(array).insertArray(index, newElements).getRaw();
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayKit.newArray(componentType, newSize);
        if (newSize > 0 && ArrayKit.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayKit.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayKit.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayKit.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    public static <T> T copy(Object src, T dest) {
        return ArrayKit.copy(src, dest, ArrayKit.length(src));
    }

    public static <T> T copy(Object src, T dest, int length) {
        return ArrayKit.copy(src, 0, dest, 0, length);
    }

    public static <T> T copy(Object src, int srcPos, T dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T object) {
        if (null == object) {
            return null;
        }
        if (ArrayKit.isArray(object)) {
            Object result;
            Class<?> componentType = object.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(object);
                result = Array.newInstance(componentType, length);
                ArrayKit.copy(object, result, length);
            } else {
                result = ((Object[])object).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array, UnaryOperator<T> editor) {
        if (null == array || null == editor) {
            return array;
        }
        ArrayList list = new ArrayList(array.length);
        for (T t : array) {
            Object modified = editor.apply(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = ArrayKit.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        if (null == array || null == predicate) {
            return array;
        }
        return ArrayKit.edit(array, t -> predicate.test(t) ? t : null);
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayKit.edit(array, UnaryOperator.identity());
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayKit.filter(array, CharsValidator::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayKit.filter(array, CharsValidator::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayKit.edit(array, t -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayKit.isEmpty(keys) || ArrayKit.isEmpty(values)) {
            return MapKit.newHashMap(0, isOrder);
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapKit.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayKit.zip(keys, values, false);
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayKit.indexOf(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ArrayKit.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        for (T value : values) {
            if (ArrayKit.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayKit.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object object) {
        if (null == object) {
            return null;
        }
        if (ArrayKit.isArray(object)) {
            try {
                String className;
                switch (className = object.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayKit.wrap((long[])object);
                    }
                    case "int": {
                        return ArrayKit.wrap((int[])object);
                    }
                    case "short": {
                        return ArrayKit.wrap((short[])object);
                    }
                    case "char": {
                        return ArrayKit.wrap((char[])object);
                    }
                    case "byte": {
                        return ArrayKit.wrap((byte[])object);
                    }
                    case "boolean": {
                        return ArrayKit.wrap((boolean[])object);
                    }
                    case "float": {
                        return ArrayKit.wrap((float[])object);
                    }
                    case "double": {
                        return ArrayKit.wrap((double[])object);
                    }
                }
                return (Object[])object;
            }
            catch (Exception e) {
                throw ExceptionKit.wrapRuntime(e);
            }
        }
        throw new InternalException(StringKit.format("[{}] is not Array!", object.getClass()));
    }

    public static <E> E get(Object array, int index) {
        return ArrayWrapper.of(array).get(index);
    }

    public static <E> E get(E[] array, Predicate<E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        if (null == array) {
            return null;
        }
        if (null == indexes) {
            return ArrayKit.newArray(array.getClass().getComponentType(), 0);
        }
        T[] result = ArrayKit.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = ArrayKit.get(array, indexes[i]);
        }
        return result;
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayKit.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StringJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array).toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, UnaryOperator<T> editor) {
        return StringJoiner.of(conjunction).append(ArrayKit.edit(array, editor)).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!ArrayKit.isArray(array)) {
            throw new IllegalArgumentException(StringKit.format("[{}] is not a Array!", array.getClass()));
        }
        return StringJoiner.of(conjunction).append(array).toString();
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        return (Object[])ArrayKit.remove(array, index);
    }

    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        return ArrayKit.remove(array, ArrayKit.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayKit.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayKit.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : numberArray) {
            if (CompareKit.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayKit.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareKit.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayKit.shuffle(array, (Random)RandomKit.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayKit.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayKit.ofArray(set, ArrayKit.getComponentType(array));
    }

    public static <T, K> T[] distinct(T[] array, Function<T, K> uniqueGenerator, boolean override) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, uniqueGenerator);
        if (override) {
            Collections.addAll(set, array);
        } else {
            for (T t : array) {
                set.addIfAbsent(t);
            }
        }
        return ArrayKit.ofArray(set, ArrayKit.getComponentType(array));
    }

    public static <T, R> R[] map(Object array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        int length = ArrayKit.length(array);
        T[] result = ArrayKit.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ArrayKit.get(array, i));
        }
        return result;
    }

    public static <T, R> List<R> mapToList(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapToSet(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toSet());
    }

    public static <T, R> R[] mapToArray(T[] array, Function<? super T, ? extends R> func, IntFunction<R[]> generator) {
        return Arrays.stream(array).map(func).toArray(generator);
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ArrayKit.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayKit.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayKit.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        Assert.notNull(array, "array must be not null !", new Object[0]);
        int length = ArrayKit.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start >= length) {
            return ArrayKit.newArray(array.getClass().getComponentType(), 0);
        }
        if (end > length) {
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static <A> A sub(A array, int beginInclude, int endExclude) {
        return ArrayWrapper.of(array).getSub(beginInclude, endExclude);
    }

    public static <A> A sub(A array, int beginInclude, int endExclude, int step) {
        return ArrayWrapper.of(array).getSub(beginInclude, endExclude, step);
    }

    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(subArray)) {
            return -1;
        }
        return ArrayKit.lastIndexOfSub(array, array.length - 1, subArray);
    }

    public static <T> int lastIndexOfSub(T[] array, int endInclude, T[] subArray) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(subArray) || subArray.length > array.length || endInclude < 0) {
            return -1;
        }
        int firstIndex = ArrayKit.lastIndexOf(array, subArray[0], endInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectKit.equals(array[i + firstIndex], subArray[i])) continue;
            return ArrayKit.lastIndexOfSub(array, firstIndex - 1, subArray);
        }
        return firstIndex;
    }

    public static <T> Boolean hasSameElement(T[] array) {
        if (ArrayKit.isEmpty(array)) {
            return false;
        }
        HashSet<T> elementSet = SetKit.of(Arrays.asList(array));
        return elementSet.size() != array.length;
    }

    public static <T> boolean startWith(T[] array, T[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (ArrayKit.isEmpty(array)) {
            return ArrayKit.isEmpty(prefix);
        }
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (!ObjectKit.notEquals(array[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }
}

