/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.miaixz.bus.core.bean.NullWrapper;
import org.miaixz.bus.core.center.stream.EasyStream;
import org.miaixz.bus.core.convert.BasicType;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.loader.classloader.JarClassLoader;
import org.miaixz.bus.core.lang.reflect.ClassScanner;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CallerKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class ClassKit {
    private static final Map<String, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();

    public static <T> Class<T> getClass(T object) {
        return null == object ? null : object.getClass();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return null == clazz ? null : clazz.getEnclosingClass();
    }

    public static String getPackageName(Class<?> clazz) {
        return ClassKit.getPackageName(clazz.getName());
    }

    public static String getPackageName(String className) {
        Assert.notNull(className, "Class name must not be null", new Object[0]);
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static boolean isTopLevelClass(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return null == ClassKit.getEnclosingClass(clazz);
    }

    public static String getClassName(Object object, boolean isSimple) {
        if (null == object) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return ClassKit.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static String getShortClassName(String className) {
        List<String> packages = CharsBacker.split(className, ".");
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StringKit.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            classes[i] = object instanceof NullWrapper ? ((NullWrapper)object).getWrappedClass() : (null == object ? Object.class : object.getClass());
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StringKit.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classFilter) {
        return ClassScanner.scanPackage(packageName, classFilter);
    }

    public static Set<String> getClassPathResources() {
        return ClassKit.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        return ClassKit.getClassPaths("", isDecode);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassKit.getClassPaths(packageName, false);
    }

    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassKit.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new InternalException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? UrlDecoder.decode(path, Charset.defaultCharset()) : path);
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassKit.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathUrl = ResourceKit.getResourceUrl("");
        String url = isEncoded ? classPathUrl.getPath() : UrlKit.getDecodedPath(classPathUrl);
        return FileKit.normalize(url);
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayKit.isEmpty(types1) && ArrayKit.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassKit.isBasicType(type1) && ClassKit.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : !type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return BasicType.isPrimitiveWrapper(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassKit.isPrimitiveWrapper(clazz);
    }

    public static boolean isBasicTypeMatch(Class<?> returnType, Class<?> fieldType) {
        if (returnType == fieldType) {
            return true;
        }
        if (null == returnType || null == fieldType) {
            return false;
        }
        if (returnType.isPrimitive() && BasicType.wrap(returnType) == fieldType) {
            return true;
        }
        return fieldType.isPrimitive() && BasicType.wrap(fieldType) == returnType;
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassKit.isSimpleValueType(clazz) || clazz.isArray() && ClassKit.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassKit.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return targetType.equals(BasicType.unWrap(sourceType));
        }
        Class<?> resolvedWrapper = BasicType.wrap(sourceType, true);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isSerializable(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !ModifierKit.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassKit.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeKit.getTypeArgument(clazz, index);
        return TypeKit.getClass(argumentType);
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassKit.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassKit.getPrimitiveDefaultValue(clazz);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> clazz) {
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz) {
            return false;
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassKit.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Package objectPackage = clazz.getPackage();
        if (null == objectPackage) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static URL getLocation(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        URL location = ClassKit.getLocation(clazz);
        if (null == location) {
            return null;
        }
        return location.getPath();
    }

    public static boolean isForName(String className, ClassLoader loader) {
        try {
            return null != ClassKit.forName(className, false, loader);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Class<?> forName(String name, ClassLoader loader) {
        return ClassKit.forName(name, false, loader);
    }

    public static Class<?> forName(String name, boolean isInitialized, ClassLoader loader) {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace('/', '.');
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - "[]".length());
            Class<?> elementClass = ClassKit.forName(elementClassName, loader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementName = name.substring("[L".length(), name.length() - 1);
            Class<?> elementClass = ClassKit.forName(elementName, loader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[")) {
            String elementName = name.substring("[".length());
            Class<?> elementClass = ClassKit.forName(elementName, loader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (null == loader) {
            loader = ClassKit.getClassLoader();
        }
        try {
            return Class.forName(name, isInitialized, loader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> clazz = ClassKit.forNameInnerClass(name, isInitialized, loader);
            if (null == clazz) {
                throw new InternalException(ex);
            }
            return clazz;
        }
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList superclasses = new ArrayList();
        ClassKit.traverseTypeHierarchy(clazz, t -> !t.isInterface(), superclasses::add, false);
        return superclasses;
    }

    public static List<Class<?>> getInterfaces(Class<?> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        ArrayList interfaces = new ArrayList();
        ClassKit.traverseTypeHierarchy(cls, t -> true, t -> {
            if (t.isInterface()) {
                interfaces.add((Class<?>)t);
            }
        }, false);
        return interfaces;
    }

    public static void traverseTypeHierarchyWhile(Class<?> root, Predicate<Class<?>> terminator) {
        ClassKit.traverseTypeHierarchyWhile(root, t -> true, terminator);
    }

    public static void traverseTypeHierarchyWhile(Class<?> root, Predicate<Class<?>> filter, Predicate<Class<?>> terminator) {
        ((EasyStream)EasyStream.iterateHierarchies(root, ClassKit::getNextTypeHierarchies, filter).takeWhile((Predicate)terminator)).exec();
    }

    public static void traverseTypeHierarchy(Class<?> root, Predicate<Class<?>> filter, Consumer<Class<?>> consumer, boolean includeRoot) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(filter);
        Objects.requireNonNull(consumer);
        Function<Class, Collection> function = t -> {
            if (includeRoot || !root.equals(t)) {
                consumer.accept((Class<?>)t);
            }
            return ClassKit.getNextTypeHierarchies(t);
        };
        EasyStream.iterateHierarchies(root, function, filter).exec();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = CallerKit.getCallers().getClassLoader();
        if (null == classLoader) {
            classLoader = ClassKit.getContextClassLoader();
        }
        if (classLoader == null && null == (classLoader = ClassKit.class.getClassLoader())) {
            classLoader = ClassKit.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getCallerClassLoader() {
        return CallerKit.getCallers().getClassLoader();
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static <T> Class<T> loadClass(String name) throws InternalException {
        return ClassKit.loadClass(name, true);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized) throws InternalException {
        return ClassKit.loadClass(name, isInitialized, null);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized, ClassLoader classLoader) throws InternalException {
        return ReflectKit.nameToClass(name, isInitialized, classLoader);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassKit.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InternalException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassKit.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassKit.loadClass(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (null != cls && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    private static Class<?> forNameInnerClass(String name, boolean isInitialized, ClassLoader classLoader) {
        int lastDotIndex = ((String)name).lastIndexOf(46);
        Class<?> clazz = null;
        while (lastDotIndex > 0 && Character.isUpperCase(((String)name).charAt(lastDotIndex + 1))) {
            name = ((String)name).substring(0, lastDotIndex) + "$" + ((String)name).substring(lastDotIndex + 1);
            try {
                clazz = Class.forName((String)name, isInitialized, classLoader);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                lastDotIndex = ((String)name).lastIndexOf(46);
            }
        }
        return clazz;
    }

    private static Set<Class<?>> getNextTypeHierarchies(Class<?> clazz) {
        LinkedHashSet next = new LinkedHashSet();
        Class<?> superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass)) {
            next.add(superclass);
        }
        next.addAll(Arrays.asList(clazz.getInterfaces()));
        return next;
    }
}

