/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.CollectionOperation;
import org.miaixz.bus.core.center.CollectionStream;
import org.miaixz.bus.core.center.TransCollection;
import org.miaixz.bus.core.center.function.BiConsumerX;
import org.miaixz.bus.core.center.function.Consumer3X;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.center.iterator.IteratorEnumeration;
import org.miaixz.bus.core.center.set.UniqueKeySet;
import org.miaixz.bus.core.codec.hash.Hash32;
import org.miaixz.bus.core.compare.PinyinCompare;
import org.miaixz.bus.core.compare.PropertyCompare;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.text.CharsValidator;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StreamKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class CollKit
extends CollectionStream {
    public static <T> Predicate<T> distinct(Function<? super T, ?> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(key.apply(t), Boolean.TRUE) == null;
    }

    public static <T> List<T> distinct(Collection<T> collection) {
        if (CollKit.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T, K> List<T> distinct(Collection<T> collection, Function<T, K> key, boolean override) {
        if (CollKit.isEmpty(collection)) {
            return new ArrayList();
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, key);
        if (override) {
            set.addAll(collection);
        } else {
            set.addAllIfAbsent(collection);
        }
        return new ArrayList(set);
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).union();
    }

    @SafeVarargs
    public static <T> Set<T> unionDistinct(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).unionDistinct();
    }

    @SafeVarargs
    public static <T> List<T> unionAll(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).unionAll();
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> ... colls) {
        return CollectionOperation.of(colls).intersection();
    }

    @SafeVarargs
    public static <T> Set<T> intersectionDistinct(Collection<T> ... colls) {
        return CollectionOperation.of(colls).intersectionDistinct();
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        return CollectionOperation.of(coll1, coll2).disjunction();
    }

    public static <T> Collection<T> subtract(Collection<T> coll1, Collection<T> coll2) {
        if (CollKit.isEmpty(coll1) || CollKit.isEmpty(coll2)) {
            return coll1;
        }
        Collection<T> result = ObjectKit.clone(coll1);
        try {
            if (null == result) {
                result = CollKit.create(coll1.getClass());
                result.addAll(coll1);
            }
            result.removeAll(coll2);
        }
        catch (UnsupportedOperationException e) {
            result = CollKit.create(AbstractCollection.class);
            result.addAll(coll1);
            result.removeAll(coll2);
        }
        return result;
    }

    public static <T> List<T> subtractToList(Collection<T> coll1, Collection<T> coll2) {
        return CollKit.subtractToList(coll1, coll2, true);
    }

    public static <T> List<T> subtractToList(Collection<T> coll1, Collection<T> coll2, boolean isLinked) {
        if (CollKit.isEmpty(coll1)) {
            return ListKit.empty();
        }
        if (CollKit.isEmpty(coll2)) {
            // empty if block
        }
        AbstractList result = isLinked ? new LinkedList() : new ArrayList(coll1.size());
        HashSet<T> set = new HashSet<T>(coll2);
        for (T t : coll1) {
            if (set.contains(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollKit.isNotEmpty(collection) && collection.contains(value);
    }

    public static boolean safeContains(Collection<?> collection, Object value) {
        try {
            return CollKit.contains(collection, value);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<? super T> containFunc) {
        if (CollKit.isEmpty(collection)) {
            return false;
        }
        for (T t : collection) {
            if (!containFunc.test(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollKit.isEmpty(coll1) || CollKit.isEmpty(coll2)) {
            return false;
        }
        boolean isFirstSmaller = coll1.size() <= coll2.size();
        Collection<?> smallerColl = isFirstSmaller ? coll1 : coll2;
        HashSet biggerSet = isFirstSmaller ? new HashSet(coll2) : new HashSet(coll1);
        for (Object object : smallerColl) {
            if (!biggerSet.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (CollKit.isEmpty(coll1)) {
            return CollKit.isEmpty(coll2);
        }
        if (CollKit.isEmpty(coll2)) {
            return true;
        }
        if (coll1 instanceof Set) {
            return coll1.containsAll(coll2);
        }
        Iterator<?> it = coll1.iterator();
        HashSet elementsAlreadySeen = new HashSet(coll1.size(), 1.0f);
        for (Object nextElement : coll2) {
            if (elementsAlreadySeen.contains(nextElement)) continue;
            boolean foundCurrentElement = false;
            while (it.hasNext()) {
                Object p = it.next();
                elementsAlreadySeen.add(p);
                if (!Objects.equals(nextElement, p)) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IteratorKit.countMap(IteratorKit.getIter(collection));
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        return IteratorKit.join(IteratorKit.getIter(iterable), conjunction, func);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IteratorKit.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IteratorKit.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollKit.isEmpty(surplusAlaDatas)) {
            return ListKit.empty();
        }
        int size = surplusAlaDatas.size();
        int popSize = Math.min(partSize, size);
        ArrayList<T> resultList = new ArrayList<T>(popSize);
        for (int i = 0; i < popSize; ++i) {
            resultList.add(surplusAlaDatas.pop());
        }
        return resultList;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollKit.isEmpty(surplusAlaDatas)) {
            return ListKit.empty();
        }
        int size = surplusAlaDatas.size();
        int popSize = Math.min(partSize, size);
        ArrayList<T> resultList = new ArrayList<T>(popSize);
        for (int i = 0; i < popSize; ++i) {
            resultList.add(surplusAlaDatas.pop());
        }
        return resultList;
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <E, T extends Collection<E>> T empty(Class<?> collectionClass) {
        if (null == collectionClass) {
            return (T)Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            if (NavigableSet.class == collectionClass) {
                return (T)Collections.emptyNavigableSet();
            }
            if (SortedSet.class == collectionClass) {
                return (T)Collections.emptySortedSet();
            }
            return (T)Collections.emptySet();
        }
        if (List.class.isAssignableFrom(collectionClass)) {
            return (T)Collections.emptyList();
        }
        throw new IllegalArgumentException(StringKit.format("[{}] is not support to get empty!", collectionClass));
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet((o1, o2) -> {
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return CompareKit.compare(o1.toString(), o2.toString());
            });
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectKit.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> superclass = collectionType.getSuperclass();
                if (null != superclass && collectionType != superclass) {
                    return CollKit.create(superclass);
                }
                throw ExceptionKit.wrapRuntime(e);
            }
        }
        return list;
    }

    public static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        if (EnumSet.class.isAssignableFrom(collectionType)) {
            return EnumSet.noneOf(Assert.notNull(elementType));
        }
        return CollKit.create(collectionType);
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListKit.sub(list, start, end);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        return ListKit.sub(list, start, end, step);
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        return CollKit.sub(collection, start, end, 1);
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end, int step) {
        if (CollKit.isEmpty(collection)) {
            return ListKit.empty();
        }
        ArrayList<T> list = collection instanceof List ? (ArrayList<T>)collection : ListKit.of(collection);
        return CollKit.sub(list, start, end, step);
    }

    public static <T> List<List<T>> partition(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollKit.isEmpty(collection)) {
            return result;
        }
        int initSize = Math.min(collection.size(), size);
        ArrayList<T> subList = new ArrayList<T>(initSize);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(initSize);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T extends Collection<E>, E> T edit(T collection, UnaryOperator<E> editor) {
        if (null == collection || null == editor) {
            return collection;
        }
        Collection<T> collection2 = CollKit.create(collection.getClass());
        if (CollKit.isEmpty(collection)) {
            return (T)collection2;
        }
        for (E t : collection) {
            Object modified = editor.apply(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return (T)collection2;
    }

    public static <T extends Collection<E>, E> T filter(T collection, Predicate<E> predicate) {
        if (null == collection || null == predicate) {
            return collection;
        }
        return CollKit.edit(collection, t -> predicate.test(t) ? t : null);
    }

    public static <T extends Collection<E>, E> T removeAny(T collection, E ... elesRemoved) {
        collection.removeAll(SetKit.of(elesRemoved));
        return collection;
    }

    public static <T extends Iterable<E>, E> T remove(T iter, Predicate<E> predicate) {
        if (null == iter) {
            return null;
        }
        IteratorKit.remove(iter.iterator(), predicate);
        return iter;
    }

    public static <T extends Collection<E>, E> T removeNull(T collection) {
        return CollKit.remove(collection, Objects::isNull);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeEmpty(T collection) {
        return CollKit.remove(collection, CharsValidator::isEmpty);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeBlank(T collection) {
        return CollKit.remove(collection, CharsValidator::isBlank);
    }

    public static <T extends Collection<E>, E> T removeWithAddIf(T targetCollection, T resultCollection, Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Iterator<E> each = targetCollection.iterator();
        while (each.hasNext()) {
            E next = each.next();
            if (!predicate.test(next)) continue;
            resultCollection.add(next);
            each.remove();
        }
        return resultCollection;
    }

    public static <T extends Collection<E>, E> List<E> removeWithAddIf(T targetCollection, Predicate<? super E> predicate) {
        ArrayList removed = new ArrayList();
        CollKit.removeWithAddIf(targetCollection, removed, predicate);
        return removed;
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func) {
        return CollKit.map(collection, func, true);
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> mapper, boolean ignoreNull) {
        if (ignoreNull) {
            return StreamKit.of(collection).filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return StreamKit.of(collection).map(mapper).collect(Collectors.toList());
    }

    public static Collection<Object> getFieldValues(Iterable<?> collection, String fieldName) {
        return CollKit.getFieldValues(collection, fieldName, false);
    }

    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName, boolean ignoreNull) {
        return CollKit.map(collection, bean -> {
            if (bean instanceof Map) {
                return ((Map)bean).get(fieldName);
            }
            return FieldKit.getFieldValue(bean, fieldName);
        }, ignoreNull);
    }

    public static <T> List<T> getFieldValues(Iterable<?> collection, String fieldName, Class<T> elementType) {
        Collection<Object> fieldValues = CollKit.getFieldValues(collection, fieldName);
        return Convert.toList(elementType, fieldValues);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iterable, String fieldName) {
        return IteratorKit.fieldValueMap(IteratorKit.getIter(iterable), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterable<?> iterable, String fieldNameForKey, String fieldNameForValue) {
        return IteratorKit.fieldValueAsMap(IteratorKit.getIter(iterable), fieldNameForKey, fieldNameForValue);
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            return CollKit.isEmpty(list) ? null : (T)list.get(0);
        }
        return IteratorKit.getFirst(IteratorKit.getIter(iterable));
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        return IteratorKit.getFirstNoneNull(IteratorKit.getIter(iterable));
    }

    public static <T> T getFirst(Iterable<T> collection, Predicate<T> predicate) {
        return IteratorKit.getFirst(IteratorKit.getIter(collection), predicate);
    }

    public static <T> T getFirstByField(Iterable<T> collection, String fieldName, Object fieldValue) {
        return (T)CollKit.getFirst(collection, t -> {
            if (t instanceof Map) {
                Map map = (Map)t;
                Object value = map.get(fieldName);
                return ObjectKit.equals(value, fieldValue);
            }
            Object value = FieldKit.getFieldValue(t, fieldName);
            return ObjectKit.equals(value, fieldValue);
        });
    }

    public static <T> int count(Iterable<T> iterable, Predicate<T> predicate) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != predicate && !predicate.test(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> int indexOf(Collection<T> collection, Predicate<T> predicate) {
        if (CollKit.isNotEmpty(collection)) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(Collection<T> collection, Predicate<? super T> predicate) {
        if (collection instanceof List) {
            return ListKit.lastIndexOf((List)collection, predicate);
        }
        int matchIndex = -1;
        if (CollKit.isNotEmpty(collection)) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    matchIndex = index;
                }
                ++index;
            }
        }
        return matchIndex;
    }

    public static <T> int[] indexOfAll(Collection<T> collection, Predicate<T> predicate) {
        return Convert.convert(int[].class, CollKit.indexListOfAll(collection, predicate));
    }

    public static <T> List<Integer> indexListOfAll(Collection<T> collection, Predicate<T> predicate) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != collection) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return indexList;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayKit.zip(CharsBacker.splitToArray(keys, delimiter), CharsBacker.splitToArray(values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollKit.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        int entryCount;
        if (CollKit.isEmpty(keys) || CollKit.isEmpty(values)) {
            return MapKit.empty();
        }
        HashMap<K, V> map = MapKit.newHashMap(entryCount);
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        for (entryCount = Math.min(keys.size(), values.size()); entryCount > 0; --entryCount) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return map;
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(Objects.requireNonNull(iter));
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : ListKit.of(IteratorKit.getIter(iterable));
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapKit.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapKit.toMapList(listMap);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollKit.addAll(collection, value, TypeKit.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        return CollKit.addAll(collection, value, elementType, null);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType, Converter converter) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (TypeKit.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof CharSequence) {
            String arrayStr = StringKit.unWrap((CharSequence)value, '[', ']');
            iter = CharsBacker.splitTrim(arrayStr, ",").iterator();
        } else {
            iter = value instanceof Map && BeanKit.isWritableBean(TypeKit.getClass((Type)elementType)) ? new ArrayIterator<Object>(new Object[]{value}) : IteratorKit.getIter(value);
        }
        Converter convert = ObjectKit.defaultIfNull(converter, CompositeConverter::getInstance);
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        if (iterable == null) {
            return collection;
        }
        return CollKit.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            Collections.addAll(collection, values);
        }
        return collection;
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollKit.get(collection, -1);
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        return IteratorKit.get(collection.iterator(), index);
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        if (CollKit.isEmpty(collection) || ArrayKit.isEmpty(indexes)) {
            return ListKit.zero();
        }
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>(indexes.length);
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        return ListKit.sort(list, c);
    }

    public static <T> List<T> sortByProperty(Collection<T> collection, String property) {
        return CollKit.sort(collection, new PropertyCompare(property));
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListKit.sortByProperty(list, property);
    }

    public static List<String> sortByPinyin(Collection<String> collection) {
        return CollKit.sort(collection, new PinyinCompare());
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListKit.sortByPinyin(list);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollKit.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        });
        return list;
    }

    public static <T> void forEach(Iterable<T> iterable, BiConsumerX<Integer, T> consumer) {
        if (iterable == null) {
            return;
        }
        CollKit.forEach(iterable.iterator(), consumer);
    }

    public static <T> void forEach(Iterator<T> iterator, BiConsumerX<Integer, T> consumer) {
        IteratorKit.forEach(iterator, consumer);
    }

    public static <T> void forEach(Enumeration<T> enumeration, BiConsumerX<Integer, T> consumer) {
        if (enumeration == null) {
            return;
        }
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(index, (Integer)enumeration.nextElement());
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, Consumer3X<Integer, K, V> kvConsumer) {
        MapKit.forEach(map, kvConsumer);
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash32<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollKit.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = t -> null == t ? 0 : t.hashCode();
        }
        for (T t2 : collection) {
            int index = hash.hash32(t2);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, ListKit.of(t2));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, ListKit.of(t2));
                continue;
            }
            subList.add(t2);
        }
        return result;
    }

    public static <T> List<List<T>> groupByField(Collection<T> collection, String fieldName) {
        return CollKit.groupByFunc(collection, t -> BeanKit.getProperty(t, fieldName));
    }

    public static <T> List<List<T>> groupByFunc(Collection<T> collection, final Function<T, ?> getter) {
        return CollKit.group(collection, new Hash32<T>(){
            private final List<Object> hashValList = new ArrayList<Object>();

            @Override
            public int hash32(T t) {
                if (null == t || !BeanKit.isWritableBean(t.getClass())) {
                    return 0;
                }
                Object value = getter.apply(t);
                int hash = this.hashValList.indexOf(value);
                if (hash < 0) {
                    this.hashValList.add(value);
                    hash = this.hashValList.size() - 1;
                }
                return hash;
            }
        });
    }

    public static <K> Set<K> keySet(Collection<Map<K, ?>> mapCollection) {
        if (CollKit.isEmpty(mapCollection)) {
            return new HashSet();
        }
        HashSet<K> set = new HashSet<K>(mapCollection.size() * 16);
        for (Map<K, ?> map : mapCollection) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public static <V> List<V> values(Collection<Map<?, V>> mapCollection) {
        if (CollKit.isEmpty(mapCollection)) {
            return ListKit.zero();
        }
        int size = 0;
        for (Map<?, V> map : mapCollection) {
            size += map.size();
        }
        if (size == 0) {
            return ListKit.zero();
        }
        ArrayList<V> values = new ArrayList<V>(size);
        for (Map<?, V> map : mapCollection) {
            values.addAll(map.values());
        }
        return values;
    }

    public static <T extends Comparable<? super T>> T max(Collection<T> coll) {
        return (T)(CollKit.isEmpty(coll) ? null : (Comparable)Collections.max(coll));
    }

    public static <T extends Comparable<? super T>> T min(Collection<T> coll) {
        return (T)(CollKit.isEmpty(coll) ? null : (Comparable)Collections.min(coll));
    }

    public static <T> Collection<T> view(Collection<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableCollection(c);
    }

    public static void clear(Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (!CollKit.isNotEmpty(collection)) continue;
            collection.clear();
        }
    }

    public static <T> void padLeft(List<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            CollKit.padRight(list, minLen, padObj);
            return;
        }
        if (list.size() >= minLen) {
            return;
        }
        if (list instanceof ArrayList) {
            list.addAll(0, Collections.nCopies(minLen - list.size(), padObj));
        } else {
            for (int i = list.size(); i < minLen; ++i) {
                list.add(0, padObj);
            }
        }
    }

    public static <T> void padRight(Collection<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        for (int i = list.size(); i < minLen; ++i) {
            list.add(padObj);
        }
    }

    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        return new TransCollection<F, T>(collection, function);
    }

    public static <E, K, V> void setValueByMap(Iterable<E> iterable, Map<K, V> map, Function<E, K> keyGenerate, BiConsumer<E, V> biConsumer) {
        iterable.forEach(x -> Optional.ofNullable(map.get(keyGenerate.apply(x))).ifPresent(y -> biConsumer.accept(x, y)));
    }

    public static <T, S extends T> boolean addIfAbsent(Collection<T> collection, S object) {
        if (object == null || collection == null || collection.contains(object)) {
            return false;
        }
        return collection.add(object);
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        if (CollKit.isEmpty(collection)) {
            return Boolean.FALSE;
        }
        return collection.stream().anyMatch(predicate);
    }

    public static <T> boolean allMatch(Collection<T> collection, Predicate<T> predicate) {
        if (CollKit.isEmpty(collection)) {
            return Boolean.FALSE;
        }
        return collection.stream().allMatch(predicate);
    }

    public static <T> List<T> flat(Collection<?> collection) {
        return CollKit.flat(collection, true);
    }

    public static <T> List<T> flat(Collection<?> collection, boolean skipNull) {
        LinkedList queue = new LinkedList(collection);
        ArrayList result = new ArrayList();
        while (CollKit.isNotEmpty(queue)) {
            Object t = queue.removeFirst();
            if (skipNull && t == null) continue;
            if (t instanceof Collection) {
                queue.addAll((Collection)t);
                continue;
            }
            result.add(t);
        }
        return result;
    }

    public static int ringNextIntByObject(Object object, AtomicInteger atomicInteger) {
        Assert.notNull(object);
        int modulo = CollKit.size(object);
        return CollKit.ringNextInt(modulo, atomicInteger);
    }

    public static int ringNextInt(int modulo, AtomicInteger atomicInteger) {
        int next;
        int current;
        Assert.notNull(atomicInteger);
        Assert.isTrue(modulo > 0);
        if (modulo <= 1) {
            return 0;
        }
        while (!atomicInteger.compareAndSet(current = atomicInteger.get(), next = (current + 1) % modulo)) {
        }
        return next;
    }

    public static long ringNextLong(long modulo, AtomicLong atomicLong) {
        long next;
        long current;
        Assert.notNull(atomicLong);
        Assert.isTrue(modulo > 0L);
        if (modulo <= 1L) {
            return 0L;
        }
        while (!atomicLong.compareAndSet(current = atomicLong.get(), next = (current + 1L) % modulo)) {
        }
        return next;
    }
}

