/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class EnumKit {
    public static boolean isEnum(Type type) {
        return Assert.notNull(TypeKit.getClass(type)).isEnum();
    }

    public static boolean isEnum(Object object) {
        return Assert.notNull(object).getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        return null != e ? e.name() : null;
    }

    public static <E extends Enum<E>> E getEnumAt(Class<E> enumClass, int index) {
        if (null == enumClass) {
            return null;
        }
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (index < 0) {
            index = enumConstants.length + index;
        }
        return (E)(index >= 0 && index < enumConstants.length ? enumConstants[index] : null);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        if (null == enumClass || StringKit.isBlank(value)) {
            return null;
        }
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        return (E)((Enum)ObjectKit.defaultIfNull(EnumKit.fromStringQuietly(enumClass, value), defaultValue));
    }

    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        if (null == enumClass || StringKit.isBlank(value)) {
            return null;
        }
        try {
            return EnumKit.fromString(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (null == enumClass || null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = FieldKit.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || StringKit.equalsAny((CharSequence)"ENUM$VALUES", "ordinal", fieldName)) continue;
            for (Enum enumObj : enums) {
                if (!ObjectKit.equals(value, FieldKit.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        if (null == clazz) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enums) {
            list.add(e.name());
        }
        return list;
    }

    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        if (null == clazz || StringKit.isBlank(fieldName)) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e : enums) {
            list.add(FieldKit.getFieldValue(e, fieldName));
        }
        return list;
    }

    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        Field[] fields;
        if (null == clazz) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields = FieldKit.getFields(clazz)) {
            String name = field.getName();
            if (field.getType().isEnum() || name.contains("$VALUES") || "ordinal".equals(name) || names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    public static <E extends Enum<E>, C> E getBy(FunctionX<E, C> condition, C value) {
        return EnumKit.getBy(condition, value, null);
    }

    public static <E extends Enum<E>, C> E getBy(FunctionX<E, C> condition, C value, E defaultEnum) {
        if (null == condition) {
            return null;
        }
        Class implClass = LambdaKit.getRealClass(condition);
        return (E)EnumKit.getBy(implClass, condition, value, defaultEnum);
    }

    public static <E extends Enum<E>, C> E getBy(Class<E> enumClass, FunctionX<E, C> condition, C value, E defaultEnum) {
        if (null == condition) {
            return null;
        }
        return (E)EnumKit.getBy(enumClass, constant -> ObjectKit.equals(condition.apply(constant), value), defaultEnum);
    }

    public static <E extends Enum<E>> E getBy(Class<E> enumClass, Predicate<? super E> predicate) {
        return EnumKit.getBy(enumClass, predicate, null);
    }

    public static <E extends Enum<E>> E getBy(Class<E> enumClass, Predicate<? super E> predicate, E defaultEnum) {
        if (null == enumClass || null == predicate) {
            return null;
        }
        return (E)((Enum)Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(predicate).findAny().orElse(defaultEnum));
    }

    public static <E extends Enum<E>, F, C> F getFieldBy(FunctionX<E, F> field, Function<E, C> condition, C value) {
        if (null == field || null == condition) {
            return null;
        }
        Class implClass = LambdaKit.getRealClass(field);
        if (Enum.class.equals(implClass)) {
            implClass = LambdaKit.getRealClass(field);
        }
        return Arrays.stream((Enum[])implClass.getEnumConstants()).filter(constant -> ObjectKit.equals(condition.apply(constant), value)).findFirst().map(field).orElse(null);
    }

    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        if (null == enumClass) {
            return null;
        }
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        if (null == clazz || StringKit.isBlank(fieldName)) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        Assert.notNull(enums, "Class [{}] is not an Enum type!", clazz);
        HashMap<String, Object> map = MapKit.newHashMap(enums.length, true);
        for (Enum<?> e : enums) {
            map.put(e.name(), FieldKit.getFieldValue(e, fieldName));
        }
        return map;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String name) {
        LinkedHashMap<String, E> enumMap = EnumKit.getEnumMap(enumClass);
        if (CollKit.isEmpty(enumMap)) {
            return false;
        }
        return enumMap.containsKey(name);
    }

    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val) {
        return !EnumKit.contains(enumClass, val);
    }

    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        return StringKit.equalsIgnoreCase(EnumKit.toString(e), val);
    }

    public static boolean equals(Enum<?> e, String val) {
        return StringKit.equals(EnumKit.toString(e), val);
    }
}

