/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.lookup.LookupFactory;
import org.miaixz.bus.core.lang.reflect.lookup.MethodLookupFactory;
import org.miaixz.bus.core.xyz.CallerKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class LookupKit {
    private static final LookupFactory factory = new MethodLookupFactory();

    public static MethodHandles.Lookup lookup() {
        return LookupKit.lookup(CallerKit.getCaller());
    }

    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return factory.lookup(callerClass);
    }

    public static MethodHandle unreflect(Member methodOrConstructor) throws InternalException {
        try {
            if (methodOrConstructor instanceof Method) {
                return LookupKit.unreflectMethod((Method)methodOrConstructor);
            }
            return LookupKit.lookup().unreflectConstructor((Constructor)methodOrConstructor);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e);
        }
    }

    public static MethodHandle unreflectMethod(Method method) throws IllegalAccessException {
        Class<?> caller = method.getDeclaringClass();
        MethodHandles.Lookup lookup = LookupKit.lookup(caller);
        if (ModifierKit.isDefault(method)) {
            return lookup.unreflectSpecial(method, caller);
        }
        try {
            return lookup.unreflect(method);
        }
        catch (Exception ignore) {
            return lookup.unreflectSpecial(method, caller);
        }
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, Class<?> returnType, Class<?> ... argTypes) {
        return LookupKit.findMethod(callerClass, name, MethodType.methodType(returnType, argTypes));
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, MethodType type) {
        if (StringKit.isBlank(name)) {
            return LookupKit.findConstructor(callerClass, type);
        }
        MethodHandle handle = null;
        MethodHandles.Lookup lookup = LookupKit.lookup(callerClass);
        try {
            handle = lookup.findVirtual(callerClass, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (null == handle) {
            try {
                handle = lookup.findStatic(callerClass, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (null == handle) {
            try {
                handle = lookup.findSpecial(callerClass, name, type, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new InternalException(e);
            }
        }
        return handle;
    }

    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... argTypes) {
        Constructor<?> constructor = ReflectKit.getConstructor(callerClass, argTypes);
        if (null != constructor) {
            return LookupKit.unreflect(constructor);
        }
        return null;
    }

    public static MethodHandle findConstructorExact(Class<?> callerClass, Class<?> ... argTypes) {
        return LookupKit.findConstructor(callerClass, MethodType.methodType(Void.TYPE, argTypes));
    }

    public static MethodHandle findConstructor(Class<?> callerClass, MethodType type) {
        MethodHandles.Lookup lookup = LookupKit.lookup(callerClass);
        try {
            return lookup.findConstructor(callerClass, type);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e);
        }
    }
}

