/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.function.Consumer3X;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.center.map.CamelCaseLinkedMap;
import org.miaixz.bus.core.center.map.CamelCaseMap;
import org.miaixz.bus.core.center.map.MapBuilder;
import org.miaixz.bus.core.center.map.MapGets;
import org.miaixz.bus.core.center.map.MapJoiner;
import org.miaixz.bus.core.center.map.MapProxy;
import org.miaixz.bus.core.center.map.MapWrapper;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MapKit
extends MapGets {
    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map, T defaultMap) {
        return MapKit.isEmpty(map) ? defaultMap : map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapKit.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapKit.newHashMap(16, isLinked);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (MapKit.isNotEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapKit.createMap(mapType, HashMap::new);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, Supplier<Map<K, V>> defaultMap) {
        Map result = null;
        if (null != mapType && !mapType.isAssignableFrom(AbstractMap.class)) {
            try {
                result = (Map)ReflectKit.newInstanceIfPossible(mapType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == result) {
            result = defaultMap.get();
        }
        if (!result.isEmpty()) {
            result.clear();
        }
        return result;
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapKit.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapKit.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> ofKvs(boolean isLinked, Object ... keysAndValues) {
        if (ArrayKit.isEmpty(keysAndValues)) {
            return MapKit.newHashMap(0, isLinked);
        }
        Assert.isTrue(keysAndValues.length % 2 == 0, "keysAndValues not in pairs!", new Object[0]);
        HashMap<Object, Object> map = MapKit.newHashMap(keysAndValues.length / 2, isLinked);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<K, V> ... entries) {
        return MapKit.ofEntries(new ArrayIterator<Map.Entry<K, V>>((E[])entries));
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterable<Map.Entry<K, V>> entryIter) {
        return MapKit.ofEntries(IteratorKit.getIter(entryIter));
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterator<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IteratorKit.isNotEmpty(entryIter)) {
            while (entryIter.hasNext()) {
                Map.Entry<K, V> entry = entryIter.next();
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                Object[] entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                Iterator iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                Object key = iter.next();
                if (!iter.hasNext()) continue;
                Object value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                Iterator iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                Object key = iter.next();
                if (!iter.hasNext()) continue;
                Object value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StringKit.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<Object, List> resultMap = new HashMap<Object, List>();
        if (CollKit.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                resultMap.computeIfAbsent(entry.getKey(), k -> new ArrayList()).add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        if (MapKit.isEmpty(listMap)) {
            return ListKit.zero();
        }
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
            Iterator<V> iterator = IteratorKit.getIter(entry.getValue());
            if (IteratorKit.isEmpty(iterator)) continue;
            K key = entry.getKey();
            for (Map map : resultList) {
                if (!iterator.hasNext()) break;
                map.put(key, iterator.next());
            }
            while (iterator.hasNext()) {
                resultList.add(MapKit.of(key, iterator.next()));
            }
        }
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapKit.join(map, separator, keyValueSeparator, false, otherParams);
    }

    public static String sortJoin(Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapKit.join(MapKit.sort(params), separator, keyValueSeparator, isIgnoreNull, otherParams);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapKit.join(map, separator, keyValueSeparator, true, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapKit.join(map, separator, keyValueSeparator, (Map.Entry<K, V> entry) -> !isIgnoreNull || entry.getKey() != null && entry.getValue() != null, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, Predicate<Map.Entry<K, V>> predicate, String ... otherParams) {
        return MapJoiner.of(separator, keyValueSeparator).append(map, predicate).append(otherParams).toString();
    }

    public static <K, V> Map<K, V> edit(Map<K, V> map, UnaryOperator<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map map2 = MapKit.createMap(map.getClass(), () -> new HashMap(map.size(), 1.0f));
        if (MapKit.isEmpty(map)) {
            return map2;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry modified = (Map.Entry)editor.apply(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (null == map || null == predicate) {
            return map;
        }
        return MapKit.edit(map, t -> predicate.test((Map.Entry)t) ? t : null);
    }

    public static <K, V, R> Map<K, R> map(Map<K, V> map, BiFunction<K, V, R> biFunction) {
        if (null == map || null == biFunction) {
            return MapKit.newHashMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> biFunction.apply(m.getKey(), m.getValue())));
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        if (null == map || null == keys) {
            return map;
        }
        Map<K, V> map2 = MapKit.createMap(map.getClass(), () -> new HashMap(map.size(), 1.0f));
        if (MapKit.isEmpty(map)) {
            return map2;
        }
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapKit.edit(map, t -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = MapKit.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapKit.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            TreeMap result = (TreeMap)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        }
        return MapKit.newTreeMap(map, comparator);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (isDesc) {
            entryComparator = entryComparator.reversed();
        }
        map.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> result.put(e.getKey(), (Comparable)e.getValue()));
        return result;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.of(map);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> view(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapKit.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapKit.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return MapKit.filter(map, entry -> ArrayKit.contains(keys, entry.getKey()));
    }

    public static <K, V, T extends Map<K, V>> T removeAny(T map, K ... keys) {
        for (K key : keys) {
            map.remove(key);
        }
        return map;
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapKit.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StringKit.format("The data '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        return MapKit.removeIf(map, entry -> null == entry.getValue());
    }

    public static <K, V> Map<K, V> removeByValue(Map<K, V> map, V value) {
        return MapKit.removeIf(map, entry -> ObjectKit.equals(value, entry.getValue()));
    }

    public static <K, V> Map<K, V> removeIf(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (MapKit.isEmpty(map)) {
            return map;
        }
        map.entrySet().removeIf(predicate);
        return map;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> zero() {
        return new HashMap(0, 1.0f);
    }

    public static <K, V> Map<K, V> singleton(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        if (null == mapClass) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StringKit.format("[{}] is not support to get empty!", mapClass));
    }

    public static void clear(Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            if (!MapKit.isNotEmpty(map)) continue;
            map.clear();
        }
    }

    public static <K, V> List<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        return MapKit.valuesOfKeys(map, new ArrayIterator<K>(keys));
    }

    public static <K, V> List<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return MapKit.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> List<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> list = new ArrayList<V>();
        while (keys.hasNext()) {
            list.add(map.get(keys.next()));
        }
        return list;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return MapKit.entry(key, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key, value) : new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<V> iterable, Function<V, K> keyMapper) {
        return MapKit.putAll(resultMap, iterable, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return MapKit.putAll(resultMap, IteratorKit.getIter(iterable), keyMapper, valueMapper);
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterator<V> iterator, Function<V, K> keyMapper) {
        return MapKit.putAll(resultMap, iterator, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterator<T> iterator, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapKit.newHashMap();
        }
        if (ObjectKit.isNull(iterator)) {
            return resultMap;
        }
        while (iterator.hasNext()) {
            T value = iterator.next();
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> grouping(Iterable<Map.Entry<K, V>> entries) {
        if (CollKit.isEmpty(entries)) {
            return MapKit.zero();
        }
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (Map.Entry<K, V> pair : entries) {
            List values = map.computeIfAbsent(pair.getKey(), k -> new ArrayList());
            values.add(pair.getValue());
        }
        return map;
    }

    public static <K, V> List<Map<K, V>> partition(Map<K, V> map, int size) {
        Assert.notNull(map);
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        ArrayList<Map<K, V>> list = new ArrayList<Map<K, V>>();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap<K, V> subMap = new HashMap<K, V>(size);
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                Map.Entry<K, V> entry = iterator.next();
                subMap.put(entry.getKey(), entry.getValue());
            }
            list.add(subMap);
        }
        return list;
    }

    public static <K, V> V firstMatchValue(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        Map.Entry<K, V> kvEntry = MapKit.firstMatch(map, predicate);
        if (null != kvEntry) {
            return kvEntry.getValue();
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> firstMatch(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (MapKit.isNotEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    public static <K, V> void forEach(Map<K, V> map, Consumer3X<Integer, K, V> kvConsumer) {
        if (map == null) {
            return;
        }
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(index, entry.getKey(), entry.getValue());
            ++index;
        }
    }
}

