/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.miaixz.bus.core.lang.ref.Ref;
import org.miaixz.bus.core.lang.ref.ReferenceType;
import org.miaixz.bus.core.xyz.ObjectKit;

public class ReferKit {
    public static <T> Reference<T> of(ReferenceType type, T referent) {
        return ReferKit.of(type, referent, null);
    }

    public static <T> Reference<T> of(ReferenceType type, T referent, ReferenceQueue<T> queue) {
        switch (type) {
            case SOFT: {
                return new SoftReference<T>(referent, queue);
            }
            case WEAK: {
                return new WeakReference<T>(referent, queue);
            }
            case PHANTOM: {
                return new PhantomReference<T>(referent, queue);
            }
        }
        return null;
    }

    public static <T> T get(Reference<T> object) {
        return (T)ObjectKit.apply(object, Reference::get);
    }

    public static <T> T get(Ref<T> object) {
        return (T)ObjectKit.apply(object, Ref::get);
    }
}

