/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.HexKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UnicodeKit {
    public static String toString(String unicode) {
        int i;
        if (StringKit.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        StringBuilder sb = new StringBuilder(len);
        int pos = 0;
        while ((i = StringKit.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
            sb.append(unicode, pos, i);
            pos = i;
            if (i + 5 >= len) break;
            try {
                char c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                sb.append(c);
                pos = i + 6;
            }
            catch (NumberFormatException e) {
                sb.append(unicode, pos, i + 2);
                pos = i + 2;
            }
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }

    public static String toUnicode(char c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(int c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(CharSequence text) {
        return UnicodeKit.toUnicode(text, true);
    }

    public static String toUnicode(CharSequence text, boolean isSkipAscii) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toStringOrNull(text);
        }
        int len = text.length();
        StringBuilder unicode = new StringBuilder(text.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (isSkipAscii && CharKit.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexKit.toUnicodeHex(c));
        }
        return unicode.toString();
    }
}

