/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.io.compress.Deflate;
import org.miaixz.bus.core.io.compress.Gzip;
import org.miaixz.bus.core.io.compress.ZipCopyVisitor;
import org.miaixz.bus.core.io.compress.ZipReader;
import org.miaixz.bus.core.io.compress.ZipWriter;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.io.stream.LimitedInputStream;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class ZipKit {
    private static final Charset DEFAULT_CHARSET = org.miaixz.bus.core.lang.Charset.defaultCharset();

    public static File zip(String srcPath) throws InternalException {
        return ZipKit.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws InternalException {
        return ZipKit.zip(FileKit.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws InternalException {
        return ZipKit.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws InternalException {
        File zipFile = FileKit.file(srcFile.getParentFile(), FileName.mainName(srcFile) + ".zip");
        ZipKit.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws InternalException {
        return ZipKit.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws InternalException {
        return ZipKit.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws InternalException {
        File srcFile = FileKit.file(srcPath);
        File zipFile = FileKit.file(zipPath);
        ZipKit.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws InternalException {
        return ZipKit.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws InternalException {
        return ZipKit.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws InternalException {
        ZipKit.validateFiles(zipFile, srcFiles);
        ZipWriter.of(zipFile, charset).add(withSrcDir, filter, srcFiles).close();
        return zipFile;
    }

    public static void zip(OutputStream out, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws InternalException {
        ZipWriter.of(out, charset).add(withSrcDir, filter, srcFiles).close();
    }

    public static File zip(File zipFile, String path, String data) throws InternalException {
        return ZipKit.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws InternalException {
        return ZipKit.zip(zipFile, path, IoKit.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws InternalException {
        return ZipKit.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws InternalException {
        return ZipKit.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws InternalException {
        return ZipKit.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) throws InternalException {
        try (ZipWriter zipWriter = ZipWriter.of(zipFile, charset);){
            zipWriter.add(paths, ins);
        }
        return zipFile;
    }

    public static void zip(OutputStream out, String[] paths, InputStream[] ins) {
        ZipKit.zip(ZipKit.getZipOutputStream(out, DEFAULT_CHARSET), paths, ins);
    }

    public static void zip(ZipOutputStream zipOutputStream, String[] paths, InputStream[] ins) throws InternalException {
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            zipWriter.add(paths, ins);
        }
    }

    public static File zip(File zipFile, Charset charset, Resource ... resources) throws InternalException {
        ZipWriter.of(zipFile, charset).add(resources).close();
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws InternalException {
        return ZipKit.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) throws InternalException {
        return ZipKit.unzip(FileKit.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws InternalException {
        return ZipKit.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) throws InternalException {
        File destDir = FileKit.file(zipFile.getParentFile(), FileName.mainName(zipFile));
        return ZipKit.unzip(zipFile, destDir, charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws InternalException {
        return ZipKit.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws InternalException {
        return ZipKit.unzip(FileKit.file(zipFilePath), FileKit.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws InternalException {
        return ZipKit.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) {
        return ZipKit.unzip(ZipKit.toZipFile(zipFile, charset), outFile);
    }

    public static File unzip(ZipFile zipFile, File outFile) throws InternalException {
        return ZipKit.unzip(zipFile, outFile, -1L);
    }

    public static File unzip(ZipFile zipFile, File outFile, long limit) throws InternalException {
        if (outFile.exists() && outFile.isFile()) {
            throw new IllegalArgumentException(StringKit.format("Target path [{}] exist!", outFile.getAbsolutePath()));
        }
        if (limit > 0L) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            long zipFileSize = 0L;
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if ((zipFileSize += zipEntry.getSize()) <= limit) continue;
                throw new IllegalArgumentException("The file size exceeds the limit");
            }
        }
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, Charset charset) throws InternalException {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipKit.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) throws InternalException {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipKit.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) {
        return ZipKit.unzipFileBytes(FileKit.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipKit.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) {
        try (ZipReader reader = ZipReader.of(zipFile, charset);){
            byte[] byArray = IoKit.readBytes(reader.get(name));
            return byArray;
        }
    }

    public static byte[] gzip(String content, Charset charset) throws InternalException {
        return ZipKit.gzip(ByteKit.toBytes(content, charset));
    }

    public static byte[] gzip(byte[] buf) throws InternalException {
        return ZipKit.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws InternalException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byArray = ZipKit.gzip(in, (int)file.length());
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        return byArray;
    }

    public static byte[] gzip(InputStream in) throws InternalException {
        return ZipKit.gzip(in, 64);
    }

    public static byte[] gzip(InputStream in, int length) throws InternalException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(in, bos).gzip().close();
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, Charset charset) throws InternalException {
        return StringKit.toString(ZipKit.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws InternalException {
        return ZipKit.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws InternalException {
        return ZipKit.unGzip(in, 64);
    }

    public static byte[] unGzip(InputStream in, int length) throws InternalException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(length);
        Gzip.of(in, bos).unGzip().close();
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, Charset charset, int level) {
        return ZipKit.zlib(ByteKit.toBytes(content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byArray = ZipKit.zlib(in, level, (int)file.length());
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        return byArray;
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipKit.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipKit.zlib(in, level, 64);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).deflater(level);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, Charset charset) {
        return StringKit.toString(ZipKit.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipKit.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipKit.unZlib(in, 64);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).inflater();
        return out.toByteArray();
    }

    public static InputStream get(File zipFile, Charset charset, String path) {
        return ZipKit.get(ZipKit.toZipFile(zipFile, charset), path);
    }

    public static InputStream get(ZipFile zipFile, String path) {
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipKit.getStream(zipFile, entry);
        }
        return null;
    }

    public static void read(ZipFile zipFile, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.read(consumer);
        }
    }

    public static void read(ZipInputStream zipStream, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.read(consumer);
        }
    }

    public static void append(Path zipPath, Path appendFilePath, CopyOption ... options) throws InternalException {
        try (FileSystem zipFileSystem2 = FileKit.createZip(zipPath.toString());){
            if (Files.isDirectory(appendFilePath, new LinkOption[0])) {
                Path source = appendFilePath.getParent();
                if (null == source) {
                    source = appendFilePath;
                }
                Files.walkFileTree(appendFilePath, new ZipCopyVisitor(source, zipFileSystem2, options));
            } else {
                Files.copy(appendFilePath, zipFileSystem2.getPath(PathResolve.getName(appendFilePath), new String[0]), options);
            }
        }
        catch (FileAlreadyExistsException zipFileSystem2) {
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static ZipFile toZipFile(File file, Charset charset) {
        if (null == charset) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        try {
            return new ZipFile(file, charset);
        }
        catch (IOException e) {
            if (e instanceof ZipException && e.getMessage().contains("invalid CEN header")) {
                try {
                    return new ZipFile(file, org.miaixz.bus.core.lang.Charset.UTF_8.equals(charset) ? org.miaixz.bus.core.lang.Charset.GBK : org.miaixz.bus.core.lang.Charset.UTF_8);
                }
                catch (IOException ex) {
                    throw new InternalException(ex);
                }
            }
            throw new InternalException(e);
        }
    }

    public static InputStream getStream(ZipFile zipFile, ZipEntry zipEntry) {
        try {
            return new LimitedInputStream(zipFile.getInputStream(zipEntry), zipEntry.getSize());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StringKit.isNotBlank(dir)) {
            dir = StringKit.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : new EnumerationIterator<ZipEntry>(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StringKit.isEmpty(dir) && !name.startsWith(dir) || !StringKit.isNotEmpty(nameSuffix = StringKit.removePrefix(name, dir)) || StringKit.contains((CharSequence)nameSuffix, '/')) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    public static JarFile ofJar(String jarFileUrl) throws InternalException {
        Assert.notBlank(jarFileUrl, "Jar file url is blank!", new Object[0]);
        if (jarFileUrl.startsWith("file:")) {
            try {
                jarFileUrl = UrlKit.toURI(jarFileUrl).getSchemeSpecificPart();
            }
            catch (InternalException e) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
        }
        try {
            return new JarFile(jarFileUrl);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws InternalException {
        if (zipFile.isDirectory()) {
            throw new InternalException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            File parentFile;
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new InternalException(StringKit.format("File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                parentFile = zipFile.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                parentFile = zipFile.getParentFile();
            }
            if (!srcFile.isDirectory() || !FileKit.isSub(srcFile, parentFile)) continue;
            throw new InternalException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getPath(), srcFile.getPath());
        }
    }
}

