/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class ZoneKit {
    public static final TimeZone ZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final ZoneId ZONE_ID_UTC = ZONE_UTC.toZoneId();

    public static TimeZone toTimeZone(ZoneId zoneId) {
        if (null == zoneId) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(zoneId);
    }

    public static ZoneId toZoneId(TimeZone timeZone) {
        if (null == timeZone) {
            return ZoneId.systemDefault();
        }
        return timeZone.toZoneId();
    }

    public static TimeZone getTimeZoneByOffset(int rawOffset, TimeUnit timeUnit) {
        String id = ZoneKit.getAvailableID(rawOffset, timeUnit);
        return null == id ? null : TimeZone.getTimeZone(id);
    }

    public static String getAvailableID(int rawOffset, TimeUnit timeUnit) {
        String[] availableIDs = TimeZone.getAvailableIDs((int)ObjectKit.defaultIfNull(timeUnit, TimeUnit.MILLISECONDS).toMillis(rawOffset));
        return ArrayKit.isEmpty(availableIDs) ? null : availableIDs[0];
    }
}

