/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.basic.normal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.I18n;

public class ErrorRegistry
implements Errors {
    private final String key;
    private final String value;

    public ErrorRegistry(Builder builder) {
        if (builder.key == null || builder.value == null) {
            throw new IllegalArgumentException("key\u548cvalue\u4e0d\u80fd\u4e3anull");
        }
        this.key = builder.key;
        this.value = builder.value;
        this.register();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.getValue(I18n.AUTO_DETECT);
    }

    public String getValue(I18n i18n) {
        try {
            Locale locale = i18n == I18n.AUTO_DETECT ? Locale.getDefault() : new Locale(i18n.lang());
            ResourceBundle bundle = ResourceBundle.getBundle("messages", locale);
            return bundle.getString(this.key);
        }
        catch (Exception e) {
            Errors.Entry entry = Errors.require(this.key);
            return entry != null ? entry.getValue() : this.value;
        }
    }

    public static class Builder {
        private String key;
        private String value;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public ErrorRegistry build() {
            return new ErrorRegistry(this);
        }
    }
}

