/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.basic.normal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.lang.exception.AlreadyExistsException;

public interface Errors {
    public static final Map<String, Entry> ERRORS_CACHE = new ConcurrentHashMap<String, Entry>();

    public String getKey();

    public String getValue();

    default public void register() {
        if (ERRORS_CACHE.containsKey(this.getKey())) {
            throw new AlreadyExistsException("Key already exists for : " + this.getKey());
        }
        ERRORS_CACHE.putIfAbsent(this.getKey(), new Entry(this.getKey(), this.getValue()));
    }

    public static boolean contains(String code) {
        return ERRORS_CACHE.containsKey(code);
    }

    public static Entry require(String key) {
        return ERRORS_CACHE.get(key);
    }

    public static class Entry
    implements Errors {
        private final String key;
        private final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

