/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.bean.copier.AbstractCopier;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class BeanToMapCopier
extends AbstractCopier<Object, Map> {
    private final Type[] typeArguments;

    public BeanToMapCopier(Object source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.typeArguments = TypeKit.getTypeArguments(targetType);
    }

    @Override
    public Map copy() {
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = this.source.getClass();
        if (null != copyOptions.editable) {
            Assert.isTrue(copyOptions.editable.isInstance(this.source), "Source class [{}] not assignable to Editable class [{}]", actualEditable.getName(), copyOptions.editable.getName());
            actualEditable = copyOptions.editable;
        }
        Map<String, PropDesc> sourcePropDescMap = this.getBeanDesc(actualEditable).getPropMap(copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, copyOptions.ignoreError);
            if (!copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<Object, Object> entry = copyOptions.editField(sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = StringKit.toStringOrNull(entry.getKey());
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            if (null != this.typeArguments && this.typeArguments.length > 1) {
                sValue = copyOptions.convertField(this.typeArguments[1], sValue);
            }
            if (null != sValue || !copyOptions.ignoreNullValue) {
                ((Map)this.target).put(sFieldName, sValue);
            }
        });
        return (Map)this.target;
    }
}

