/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.LockedCache;
import org.miaixz.bus.core.lang.thread.lock.NoLock;

public class LFUCache<K, V>
extends LockedCache<K, V> {
    private static final long serialVersionUID = 2852231672235L;

    public LFUCache(int capacity) {
        this(capacity, 0L);
    }

    public LFUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.lock = NoLock.INSTANCE;
        this.cacheMap = new ConcurrentHashMap(capacity + 1, 1.0f);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObject comin = null;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObject co = values.next();
            if (co.isExpired()) {
                values.remove();
                this.onRemove(co.key, co.object);
                ++count;
                continue;
            }
            if (comin != null && co.accessCount.get() >= comin.accessCount.get()) continue;
            comin = co;
        }
        if (this.isFull() && comin != null) {
            long minAccessCount = comin.accessCount.get();
            values = this.cacheObjIter();
            while (values.hasNext()) {
                CacheObject co1 = values.next();
                if (co1.accessCount.addAndGet(-minAccessCount) > 0L) continue;
                values.remove();
                this.onRemove(co1.key, co1.object);
                ++count;
            }
        }
        return count;
    }
}

