/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.miaixz.bus.core.cache.GlobalPruneTimer;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.LockedCache;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.lang.thread.lock.NoLock;

public class TimedCache<K, V>
extends LockedCache<K, V> {
    private static final long serialVersionUID = 2852232272208L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap<Mutable<K>, CacheObject<K, V>>());
    }

    public TimedCache(long timeout, Map<Mutable<K>, CacheObject<K, V>> map) {
        this.capacity = 0;
        this.lock = map instanceof ConcurrentMap ? NoLock.INSTANCE : new ReentrantLock();
        this.cacheMap = Assert.isNotInstanceOf(LinkedHashMap.class, map);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObject co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.object);
            ++count;
        }
        return count;
    }

    public TimedCache<K, V> schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay);
        return this;
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

