/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Date;
import org.miaixz.bus.core.center.date.Calendar;
import org.miaixz.bus.core.center.date.culture.en.Units;
import org.miaixz.bus.core.center.date.format.FormatPeriod;
import org.miaixz.bus.core.lang.Assert;

public class Between
implements Serializable {
    private static final long serialVersionUID = 2852233282300L;
    private final Date begin;
    private final Date end;

    public Between(Date begin, Date end) {
        this(begin, end, true);
    }

    public Between(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public static Between of(Date begin, Date end) {
        return new Between(begin, end);
    }

    public static Between of(Date begin, Date end, boolean isAbs) {
        return new Between(begin, end, isAbs);
    }

    public static Duration between(Temporal startTimeInclude, Temporal endTimeExclude) {
        return Duration.between(startTimeInclude, endTimeExclude);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return Between.between(startTimeInclude, endTimeExclude);
    }

    public static long between(Temporal startTimeInclude, Temporal endTimeExclude, ChronoUnit unit) {
        return unit.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        return Between.between(startTimeInclude, endTimeExclude, unit);
    }

    public static Period between(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public long between(Units unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }

    public long betweenMonth(boolean isReset) {
        java.util.Calendar beginCal = Calendar.calendar(this.begin);
        java.util.Calendar endCal = Calendar.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        int endMonthBase0;
        java.util.Calendar beginCal = Calendar.calendar(this.begin);
        java.util.Calendar endCal = Calendar.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (isReset) {
            return result;
        }
        int beginMonthBase0 = beginCal.get(2);
        if (beginMonthBase0 < (endMonthBase0 = endCal.get(2))) {
            return result;
        }
        if (beginMonthBase0 > endMonthBase0) {
            return result - 1;
        }
        if (1 == beginMonthBase0 && Calendar.isLastDayOfMonth(beginCal) && Calendar.isLastDayOfMonth(endCal)) {
            beginCal.set(5, 1);
            endCal.set(5, 1);
        }
        endCal.set(1, beginCal.get(1));
        long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
        return between < 0L ? (long)(result - 1) : (long)result;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public String toString(Units unit, FormatPeriod.Level level) {
        return FormatPeriod.of(this.between(unit), level).format();
    }

    public String toString(FormatPeriod.Level level) {
        return this.toString(Units.MS, level);
    }

    public String toString() {
        return this.toString(FormatPeriod.Level.MILLISECOND);
    }
}

