/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.miaixz.bus.core.center.date.Calendar;
import org.miaixz.bus.core.center.date.Converter;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.FormatManager;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.center.date.format.parser.RegisterDateParser;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.StringKit;

public class Resolver
extends Converter {
    public static DateTime parse(CharSequence date) {
        return (DateTime)RegisterDateParser.INSTANCE.parse(date);
    }

    public static DateTime parse(CharSequence date, DateFormat format) {
        return new DateTime(date, format);
    }

    public static DateTime parse(CharSequence date, PositionDateParser parser) {
        return new DateTime(date, parser);
    }

    public static DateTime parse(CharSequence date, PositionDateParser parser, boolean lenient) {
        return new DateTime(date, parser, lenient);
    }

    public static DateTime parse(CharSequence date, DateTimeFormatter formatter) {
        return new DateTime(date, formatter);
    }

    public static DateTime parse(CharSequence date, String format) {
        return new DateTime(date, format);
    }

    public static DateTime parse(CharSequence date, String format, Locale locale) {
        FormatManager formatManager = FormatManager.getInstance();
        if (formatManager.isCustomFormat(format)) {
            return new DateTime(formatManager.parse(date, format));
        }
        return new DateTime(date, Formatter.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String date, String ... parsePatterns) throws DateException {
        return Resolver.date(Calendar.parseByPatterns((CharSequence)date, parsePatterns));
    }

    public static LocalDateTime parseTime(CharSequence date, String format) {
        if (StringKit.isBlank((CharSequence)date)) {
            return null;
        }
        FormatManager formatManager = FormatManager.getInstance();
        if (formatManager.isCustomFormat(format)) {
            return Resolver.of(formatManager.parse((CharSequence)date, format));
        }
        DateTimeFormatter formatter = null;
        if (StringKit.isNotBlank(format)) {
            if (StringKit.startWithIgnoreEquals(format, "yyyyMMddHHmmss") && format.endsWith("S")) {
                int paddingWidth = 3 - (format.length() - "yyyyMMddHHmmss".length());
                if (paddingWidth > 0) {
                    date = String.valueOf(date) + StringKit.repeat('0', paddingWidth);
                }
                formatter = Formatter.PURE_DATETIME_MS_FORMATTER;
            } else {
                formatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return Resolver.parseTime((CharSequence)date, formatter);
    }

    public static LocalDateTime parseTime(CharSequence date, DateTimeFormatter formatter) {
        if (StringKit.isBlank(date)) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(date);
        }
        return Resolver.of(formatter.parse(date));
    }

    public static LocalDate parseDate(CharSequence date, String format) {
        if (StringKit.isBlank(date)) {
            return null;
        }
        return Resolver.parseDate(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate parseDate(CharSequence date, DateTimeFormatter formatter) {
        if (StringKit.isBlank(date)) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(date);
        }
        return Resolver.ofDate(formatter.parse(date));
    }

    public static LocalDate parseDateByISO(CharSequence date) {
        return Resolver.parseDate(date, (DateTimeFormatter)null);
    }

    public static LocalDateTime parseTimeByISO(CharSequence date) {
        if (StringKit.contains(date, 'T')) {
            return Resolver.parseTime(date, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return Resolver.parseTime(date, Formatter.NORM_DATETIME_FORMATTER);
    }

    public static String normalize(CharSequence date) {
        if (StringKit.isBlank(date)) {
            return StringKit.toString(date);
        }
        List<String> dateAndTime = CharsBacker.splitTrim(date, " ");
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(date);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

