/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.eightchar;

import org.miaixz.bus.core.center.date.culture.cn.Opposite;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.ChildLimitInfo;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.DecadeFortune;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.EightChar;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.Fortune;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.provider.ChildLimitProvider;
import org.miaixz.bus.core.center.date.culture.cn.eightchar.provider.impl.DefaultChildLimitProvider;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;
import org.miaixz.bus.core.lang.Gender;

public class ChildLimit {
    public static ChildLimitProvider provider = new DefaultChildLimitProvider();
    protected EightChar eightChar;
    protected Gender gender;
    protected boolean forward;
    protected ChildLimitInfo info;

    public ChildLimit(SolarTime birthTime, Gender gender) {
        this.gender = gender;
        this.eightChar = birthTime.getLunarHour().getEightChar();
        boolean yang = Opposite.YANG == this.eightChar.getYear().getHeavenStem().getOpposite();
        boolean man = Gender.MALE == gender;
        this.forward = yang && man || !yang && !man;
        SolarTerms term = birthTime.getTerm();
        if (!term.isJie()) {
            term = term.next(-1);
        }
        if (this.forward) {
            term = term.next(2);
        }
        this.info = provider.getInfo(birthTime, term);
    }

    public static ChildLimit fromSolarTime(SolarTime birthTime, Gender gender) {
        return new ChildLimit(birthTime, gender);
    }

    public EightChar getEightChar() {
        return this.eightChar;
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean isForward() {
        return this.forward;
    }

    public int getYearCount() {
        return this.info.getYearCount();
    }

    public int getMonthCount() {
        return this.info.getMonthCount();
    }

    public int getDayCount() {
        return this.info.getDayCount();
    }

    public int getHourCount() {
        return this.info.getHourCount();
    }

    public int getMinuteCount() {
        return this.info.getMinuteCount();
    }

    public SolarTime getStartTime() {
        return this.info.getStartTime();
    }

    public SolarTime getEndTime() {
        return this.info.getEndTime();
    }

    public DecadeFortune getStartDecadeFortune() {
        return DecadeFortune.fromChildLimit(this, 0);
    }

    public DecadeFortune getDecadeFortune() {
        return DecadeFortune.fromChildLimit(this, -1);
    }

    public Fortune getStartFortune() {
        return Fortune.fromChildLimit(this, 0);
    }

    public SixtyCycleYear getStartSixtyCycleYear() {
        return SixtyCycleYear.fromYear(this.getStartTime().getYear());
    }

    public SixtyCycleYear getEndSixtyCycleYear() {
        return SixtyCycleYear.fromYear(this.getEndTime().getYear());
    }

    public int getStartAge() {
        return 1;
    }

    public int getEndAge() {
        int n = this.getEndSixtyCycleYear().getYear() - this.getStartSixtyCycleYear().getYear();
        return Math.max(n, 1);
    }
}

