/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.en;

import java.time.temporal.ChronoUnit;

public enum Units {
    MS(1L),
    SECOND(1000L),
    MINUTE(SECOND.getMillis() * 60L),
    HOUR(MINUTE.getMillis() * 60L),
    DAY(HOUR.getMillis() * 24L),
    WEEK(DAY.getMillis() * 7L);

    private final long millis;

    private Units(long millis) {
        this.millis = millis;
    }

    public static Units of(ChronoUnit unit) {
        switch (unit) {
            case MICROS: {
                return MS;
            }
            case SECONDS: {
                return SECOND;
            }
            case MINUTES: {
                return MINUTE;
            }
            case HOURS: {
                return HOUR;
            }
            case DAYS: {
                return DAY;
            }
            case WEEKS: {
                return WEEK;
            }
        }
        return null;
    }

    public static ChronoUnit toChronoUnit(Units unit) {
        switch (unit.ordinal()) {
            case 0: {
                return ChronoUnit.MICROS;
            }
            case 1: {
                return ChronoUnit.SECONDS;
            }
            case 2: {
                return ChronoUnit.MINUTES;
            }
            case 3: {
                return ChronoUnit.HOURS;
            }
            case 4: {
                return ChronoUnit.DAYS;
            }
            case 5: {
                return ChronoUnit.WEEKS;
            }
        }
        return null;
    }

    public long getMillis() {
        return this.millis;
    }

    public ChronoUnit toChronoUnit() {
        return Units.toChronoUnit(this);
    }
}

