/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.lunar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;

public class LunarWeek
extends Loops {
    protected LunarMonth month;
    protected int index;
    protected Week start;

    public LunarWeek(int year, int month, int index, int start) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException(String.format("illegal lunar week index: %d", index));
        }
        if (start < 0 || start > 6) {
            throw new IllegalArgumentException(String.format("illegal lunar week start: %d", start));
        }
        LunarMonth m = LunarMonth.fromYm(year, month);
        if (index >= m.getWeekCount(start)) {
            throw new IllegalArgumentException(String.format("illegal lunar week index: %d in month: %s", index, m));
        }
        this.month = m;
        this.index = index;
        this.start = Week.fromIndex(start);
    }

    public static LunarWeek fromYm(int year, int month, int index, int start) {
        return new LunarWeek(year, month, index, start);
    }

    public LunarMonth getLunarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public int getIndex() {
        return this.index;
    }

    public Week getStart() {
        return this.start;
    }

    @Override
    public String getName() {
        return Week.WHICH[this.index];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public LunarWeek next(int n) {
        int d;
        int startIndex = this.start.getIndex();
        if (n == 0) {
            return LunarWeek.fromYm(this.getYear(), this.getMonth(), this.index, startIndex);
        }
        LunarMonth m = this.month;
        if (n > 0) {
            int weekCount = m.getWeekCount(startIndex);
            while (d >= weekCount) {
                d -= weekCount;
                if (!LunarDay.fromYmd((m = m.next(1)).getYear(), m.getMonthWithLeap(), 1).getWeek().equals(this.start)) {
                    ++d;
                }
                weekCount = m.getWeekCount(startIndex);
            }
        } else {
            for (d = this.index + n; d < 0; d += m.getWeekCount(startIndex)) {
                if (!LunarDay.fromYmd(m.getYear(), m.getMonthWithLeap(), 1).getWeek().equals(this.start)) {
                    --d;
                }
                m = m.next(-1);
            }
        }
        return LunarWeek.fromYm(m.getYear(), m.getMonthWithLeap(), d, startIndex);
    }

    public LunarDay getFirstDay() {
        LunarDay firstDay = LunarDay.fromYmd(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    public List<LunarDay> getDays() {
        ArrayList<LunarDay> l = new ArrayList<LunarDay>(7);
        LunarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LunarWeek && this.getFirstDay().equals(((LunarWeek)o).getFirstDay());
    }
}

