/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.rabjung;

import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Zodiac;
import org.miaixz.bus.core.center.date.culture.rabjung.RabjungElement;
import org.miaixz.bus.core.center.date.culture.rabjung.RabjungMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;

public class RabjungDay
extends Loops {
    public static final String[] NAMES = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    protected RabjungMonth month;
    protected int day;
    protected boolean leap;

    public RabjungDay(RabjungMonth month, int day) {
        if (day == 0 || day < -30 || day > 30) {
            throw new IllegalArgumentException(String.format("illegal day %d in %s", day, month));
        }
        boolean leap = day < 0;
        int d = Math.abs(day);
        if (leap && !month.getLeapDays().contains(d)) {
            throw new IllegalArgumentException(String.format("illegal leap day %d in %s", d, month));
        }
        if (!leap && month.getMissDays().contains(d)) {
            throw new IllegalArgumentException(String.format("illegal day %d in %s", d, month));
        }
        this.month = month;
        this.day = d;
        this.leap = leap;
    }

    public RabjungDay(int year, int month, int day) {
        this(RabjungMonth.fromYm(year, month), day);
    }

    public RabjungDay(int rabByungIndex, RabjungElement element, Zodiac zodiac, int month, int day) {
        this(new RabjungMonth(rabByungIndex, element, zodiac, month), day);
    }

    public static RabjungDay fromYmd(int year, int month, int day) {
        return new RabjungDay(year, month, day);
    }

    public static RabjungDay fromElementZodiac(int rabByungIndex, RabjungElement element, Zodiac zodiac, int month, int day) {
        return new RabjungDay(rabByungIndex, element, zodiac, month, day);
    }

    public static RabjungDay fromSolarDay(SolarDay solarDay) {
        int days = solarDay.subtract(SolarDay.fromYmd(1951, 1, 8));
        RabjungMonth m = RabjungMonth.fromYm(1950, 12);
        int count = m.getDayCount();
        while (days >= count) {
            days -= count;
            m = m.next(1);
            count = m.getDayCount();
        }
        int day = days + 1;
        for (int d : m.getSpecialDays()) {
            if (d < 0) {
                if (day < -d) continue;
                ++day;
                continue;
            }
            if (d <= 0) continue;
            if (day == d + 1) {
                day = -d;
                break;
            }
            if (day <= d + 1) continue;
            --day;
        }
        return new RabjungDay(m, day);
    }

    public RabjungMonth getRabByungMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public int getDay() {
        return this.day;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public int getDayWithLeap() {
        return this.leap ? -this.day : this.day;
    }

    @Override
    public String getName() {
        return (this.leap ? "\u95f0" : "") + NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    public int subtract(RabjungDay target) {
        return this.getSolarDay().subtract(target.getSolarDay());
    }

    public SolarDay getSolarDay() {
        RabjungMonth m = RabjungMonth.fromYm(1950, 12);
        int n = 0;
        while (!this.month.equals(m)) {
            n += m.getDayCount();
            m = m.next(1);
        }
        int t = this.day;
        for (int d : m.getSpecialDays()) {
            if (d < 0) {
                if (t <= -d) continue;
                --t;
                continue;
            }
            if (d <= 0 || t <= d) continue;
            ++t;
        }
        if (this.leap) {
            ++t;
        }
        return SolarDay.fromYmd(1951, 1, 7).next(n + t);
    }

    @Override
    public RabjungDay next(int n) {
        return this.getSolarDay().next(n).getRabByungDay();
    }
}

