/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import org.miaixz.bus.core.center.date.Holiday;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.HiddenStems;
import org.miaixz.bus.core.center.date.culture.cn.JulianDay;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.cn.climate.Climate;
import org.miaixz.bus.core.center.date.culture.cn.climate.ClimateDay;
import org.miaixz.bus.core.center.date.culture.cn.dog.Dog;
import org.miaixz.bus.core.center.date.culture.cn.dog.DogDay;
import org.miaixz.bus.core.center.date.culture.cn.nine.Nine;
import org.miaixz.bus.core.center.date.culture.cn.nine.NineDay;
import org.miaixz.bus.core.center.date.culture.cn.plumrain.PlumRain;
import org.miaixz.bus.core.center.date.culture.cn.plumrain.PlumRainDay;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HiddenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HiddenStemDay;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleDay;
import org.miaixz.bus.core.center.date.culture.en.Constellation;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.rabjung.RabjungDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarFestival;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTermDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarWeek;

public class SolarDay
extends Loops {
    public static final String[] NAMES = new String[]{"1\u65e5", "2\u65e5", "3\u65e5", "4\u65e5", "5\u65e5", "6\u65e5", "7\u65e5", "8\u65e5", "9\u65e5", "10\u65e5", "11\u65e5", "12\u65e5", "13\u65e5", "14\u65e5", "15\u65e5", "16\u65e5", "17\u65e5", "18\u65e5", "19\u65e5", "20\u65e5", "21\u65e5", "22\u65e5", "23\u65e5", "24\u65e5", "25\u65e5", "26\u65e5", "27\u65e5", "28\u65e5", "29\u65e5", "30\u65e5", "31\u65e5"};
    protected SolarMonth month;
    protected int day;

    public SolarDay(int year, int month, int day) {
        if (day < 1) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (1582 == year && 10 == month ? day > 4 && day < 15 || day > 31 : day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        this.month = m;
        this.day = day;
    }

    public static SolarDay fromYmd(int year, int month, int day) {
        return new SolarDay(year, month, day);
    }

    public SolarMonth getSolarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonth();
    }

    public int getDay() {
        return this.day;
    }

    public Week getWeek() {
        return this.getJulianDay().getWeek();
    }

    public Constellation getConstellation() {
        int y = this.getMonth() * 100 + this.day;
        return Constellation.get(y > 1221 || y < 120 ? 9 : (y < 219 ? 10 : (y < 321 ? 11 : (y < 420 ? 0 : (y < 521 ? 1 : (y < 622 ? 2 : (y < 723 ? 3 : (y < 823 ? 4 : (y < 923 ? 5 : (y < 1024 ? 6 : (y < 1123 ? 7 : 8)))))))))));
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public SolarDay next(int n) {
        return this.getJulianDay().next(n).getSolarDay();
    }

    public boolean isBefore(SolarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear < bYear;
        }
        int aMonth = this.getMonth();
        return aMonth != (bMonth = target.getMonth()) ? aMonth < bMonth : this.day < target.getDay();
    }

    public boolean isAfter(SolarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear > bYear;
        }
        int aMonth = this.getMonth();
        return aMonth != (bMonth = target.getMonth()) ? aMonth > bMonth : this.day > target.getDay();
    }

    public SolarTerms getTerm() {
        return this.getTermDay().getSolarTerm();
    }

    public SolarTermDay getTermDay() {
        int y = this.getYear();
        int i = this.getMonth() * 2;
        if (i == 24) {
            ++y;
            i = 0;
        }
        SolarTerms term = SolarTerms.fromIndex(y, i);
        SolarDay day = term.getJulianDay().getSolarDay();
        while (this.isBefore(day)) {
            term = term.next(-1);
            day = term.getJulianDay().getSolarDay();
        }
        return new SolarTermDay(term, this.subtract(day));
    }

    public SolarWeek getSolarWeek(int start) {
        int y = this.getYear();
        int m = this.getMonth();
        return SolarWeek.fromYm(y, m, (int)Math.ceil((double)(this.day + SolarDay.fromYmd(y, m, 1).getWeek().next(-start).getIndex()) / 7.0) - 1, start);
    }

    public Climate getPhenology() {
        return this.getClimateDay().getClimate();
    }

    public ClimateDay getClimateDay() {
        SolarTermDay d = this.getTermDay();
        int dayIndex = d.getDayIndex();
        int index = dayIndex / 5;
        if (index > 2) {
            index = 2;
        }
        SolarTerms term = d.getSolarTerm();
        return new ClimateDay(Climate.fromIndex(term.getYear(), term.getIndex() * 3 + index), dayIndex - index * 5);
    }

    public DogDay getDogDay() {
        SolarTerms xiaZhi = SolarTerms.fromIndex(this.getYear(), 12);
        SolarDay start = xiaZhi.getJulianDay().getSolarDay();
        int days = this.subtract(start = start.next(start.getLunarDay().getSixtyCycle().getHeavenStem().stepsTo(6) + 20));
        if (days < 0) {
            return null;
        }
        if (days < 10) {
            return new DogDay(Dog.fromIndex(0), days);
        }
        days = this.subtract(start = start.next(10));
        if (days < 10) {
            return new DogDay(Dog.fromIndex(1), days);
        }
        start = start.next(10);
        days = this.subtract(start);
        if (xiaZhi.next(3).getJulianDay().getSolarDay().isAfter(start)) {
            if (days < 10) {
                return new DogDay(Dog.fromIndex(1), days + 10);
            }
            start = start.next(10);
            days = this.subtract(start);
        }
        return days >= 10 ? null : new DogDay(Dog.fromIndex(2), days);
    }

    public NineDay getNineDay() {
        int year = this.getYear();
        SolarDay start = SolarTerms.fromIndex(year + 1, 0).getJulianDay().getSolarDay();
        if (this.isBefore(start)) {
            start = SolarTerms.fromIndex(year, 0).getJulianDay().getSolarDay();
        }
        SolarDay end = start.next(81);
        if (this.isBefore(start) || !this.isBefore(end)) {
            return null;
        }
        int days = this.subtract(start);
        return new NineDay(Nine.fromIndex(days / 9), days % 9);
    }

    public PlumRainDay getPlumRainDay() {
        SolarTerms grainInEar = SolarTerms.fromIndex(this.getYear(), 11);
        SolarDay start = grainInEar.getJulianDay().getSolarDay();
        int add = 2 - start.getLunarDay().getSixtyCycle().getHeavenStem().getIndex();
        if (add < 0) {
            add += 10;
        }
        start = start.next(add);
        SolarTerms slightHeat = grainInEar.next(2);
        SolarDay end = slightHeat.getJulianDay().getSolarDay();
        add = 7 - end.getLunarDay().getSixtyCycle().getEarthBranch().getIndex();
        if (add < 0) {
            add += 12;
        }
        end = end.next(add);
        if (this.isBefore(start) || this.isAfter(end)) {
            return null;
        }
        return this.equals(end) ? new PlumRainDay(PlumRain.fromIndex(1), 0) : new PlumRainDay(PlumRain.fromIndex(0), this.subtract(start));
    }

    public HiddenStemDay getHideHeavenStemDay() {
        int typeIndex;
        int[] dayCounts = new int[]{3, 5, 7, 9, 10, 30};
        SolarTerms term = this.getTerm();
        if (term.isQi()) {
            term = term.next(-1);
        }
        int dayIndex = this.subtract(term.getJulianDay().getSolarDay());
        int startIndex = (term.getIndex() - 1) * 3;
        String data = "93705542220504xx1513904541632524533533105544806564xx7573304542018584xx95".substring(startIndex, startIndex + 6);
        int days = 0;
        int heavenStemIndex = 0;
        for (typeIndex = 0; typeIndex < 3; ++typeIndex) {
            int i = typeIndex * 2;
            String d = data.substring(i, i + 1);
            int count = 0;
            if (!d.equals("x")) {
                heavenStemIndex = Integer.parseInt(d);
                count = dayCounts[Integer.parseInt(data.substring(i + 1, i + 2))];
                days += count;
            }
            if (dayIndex > days) continue;
            dayIndex -= days - count;
            break;
        }
        return new HiddenStemDay(new HiddenStem(heavenStemIndex, HiddenStems.fromCode(typeIndex)), dayIndex);
    }

    public int getIndexInYear() {
        return this.subtract(SolarDay.fromYmd(this.getYear(), 1, 1));
    }

    public int subtract(SolarDay target) {
        return (int)this.getJulianDay().subtract(target.getJulianDay());
    }

    public JulianDay getJulianDay() {
        return JulianDay.fromYmdHms(this.getYear(), this.getMonth(), this.day, 0, 0, 0);
    }

    public LunarDay getLunarDay() {
        int days;
        LunarMonth m = LunarMonth.fromYm(this.getYear(), this.getMonth());
        for (days = this.subtract(m.getFirstJulianDay().getSolarDay()); days < 0; days += m.getDayCount()) {
            m = m.next(-1);
        }
        return LunarDay.fromYmd(m.getYear(), m.getMonthWithLeap(), days + 1);
    }

    public SixtyCycleDay getSixtyCycleDay() {
        return SixtyCycleDay.fromSolarDay(this);
    }

    public Holiday getHoliday() {
        return Holiday.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    public SolarFestival getFestival() {
        return SolarFestival.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    public RabjungDay getRabByungDay() {
        return RabjungDay.fromSolarDay(this);
    }
}

