/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.JulianDay;
import org.miaixz.bus.core.center.date.culture.cn.climate.Climate;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleHour;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarHour;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;

public class SolarTime
extends Loops {
    protected SolarDay day;
    protected int hour;
    protected int minute;
    protected int second;

    public SolarTime(int year, int month, int day, int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("illegal hour: %d", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("illegal minute: %d", minute));
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("illegal second: %d", second));
        }
        this.day = SolarDay.fromYmd(year, month, day);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static SolarTime fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new SolarTime(year, month, day, hour, minute, second);
    }

    public SolarDay getSolarDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDay() {
        return this.day.getDay();
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    @Override
    public String getName() {
        return String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.day, this.getName());
    }

    public boolean isBefore(SolarTime target) {
        if (!this.day.equals(target.getSolarDay())) {
            return this.day.isBefore(target.getSolarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour < target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute < target.getMinute() : this.second < target.getSecond();
    }

    public boolean isAfter(SolarTime target) {
        if (!this.day.equals(target.getSolarDay())) {
            return this.day.isAfter(target.getSolarDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour > target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute > target.getMinute() : this.second > target.getSecond();
    }

    public SolarTerms getTerm() {
        SolarTerms term = this.day.getTerm();
        if (this.isBefore(term.getJulianDay().getSolarTime())) {
            term = term.next(-1);
        }
        return term;
    }

    public Climate getPhenology() {
        Climate p = this.day.getPhenology();
        if (this.isBefore(p.getJulianDay().getSolarTime())) {
            p = p.next(-1);
        }
        return p;
    }

    public JulianDay getJulianDay() {
        return JulianDay.fromYmdHms(this.getYear(), this.getMonth(), this.getDay(), this.hour, this.minute, this.second);
    }

    public int subtract(SolarTime target) {
        int days = this.day.subtract(target.getSolarDay());
        int cs = this.hour * 3600 + this.minute * 60 + this.second;
        int ts = target.getHour() * 3600 + target.getMinute() * 60 + target.getSecond();
        int seconds = cs - ts;
        if (seconds < 0) {
            seconds += 86400;
            --days;
        }
        return seconds += days * 86400;
    }

    @Override
    public SolarTime next(int n) {
        if (n == 0) {
            return SolarTime.fromYmdHms(this.getYear(), this.getMonth(), this.getDay(), this.hour, this.minute, this.second);
        }
        int ts = this.second + n;
        int tm = this.minute + ts / 60;
        if ((ts %= 60) < 0) {
            ts += 60;
            --tm;
        }
        int th = this.hour + tm / 60;
        if ((tm %= 60) < 0) {
            tm += 60;
            --th;
        }
        int td = th / 24;
        if ((th %= 24) < 0) {
            th += 24;
            --td;
        }
        SolarDay d = this.day.next(td);
        return SolarTime.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), th, tm, ts);
    }

    public LunarHour getLunarHour() {
        LunarDay d = this.day.getLunarDay();
        return LunarHour.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), this.hour, this.minute, this.second);
    }

    public SixtyCycleHour getSixtyCycleHour() {
        return SixtyCycleHour.fromSolarTime(this);
    }
}

