/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;

public class SolarWeek
extends Loops {
    protected SolarMonth month;
    protected int index;
    protected Week start;

    public SolarWeek(int year, int month, int index, int start) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d", index));
        }
        if (start < 0 || start > 6) {
            throw new IllegalArgumentException(String.format("illegal solar week start: %d", start));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (index >= m.getWeekCount(start)) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d in month: %s", index, m));
        }
        this.month = m;
        this.index = index;
        this.start = Week.fromIndex(start);
    }

    public static SolarWeek fromYm(int year, int month, int index, int start) {
        return new SolarWeek(year, month, index, start);
    }

    public SolarMonth getSolarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonth();
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndexInYear() {
        int i = 0;
        SolarDay firstDay = this.getFirstDay();
        SolarWeek w = SolarWeek.fromYm(this.getYear(), 1, 0, this.start.getIndex());
        while (!w.getFirstDay().equals(firstDay)) {
            w = w.next(1);
            ++i;
        }
        return i;
    }

    public Week getStart() {
        return this.start;
    }

    @Override
    public String getName() {
        return Week.WHICH[this.index];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public SolarWeek next(int n) {
        SolarMonth m;
        int d;
        int startIndex;
        block5: {
            block4: {
                startIndex = this.start.getIndex();
                d = this.index;
                m = this.month;
                if (n <= 0) break block4;
                d += n;
                int weekCount = m.getWeekCount(startIndex);
                while (d >= weekCount) {
                    d -= weekCount;
                    if (!SolarDay.fromYmd((m = m.next(1)).getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                        ++d;
                    }
                    weekCount = m.getWeekCount(startIndex);
                }
                break block5;
            }
            if (n >= 0) break block5;
            d += n;
            while (d < 0) {
                if (!SolarDay.fromYmd(m.getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                    --d;
                }
                m = m.next(-1);
                d += m.getWeekCount(startIndex);
            }
        }
        return SolarWeek.fromYm(m.getYear(), m.getMonth(), d, startIndex);
    }

    public SolarDay getFirstDay() {
        SolarDay firstDay = SolarDay.fromYmd(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    public List<SolarDay> getDays() {
        ArrayList<SolarDay> l = new ArrayList<SolarDay>(7);
        SolarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SolarWeek && this.getFirstDay().equals(((SolarWeek)o).getFirstDay());
    }
}

