/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import org.miaixz.bus.core.center.date.format.parser.DateParser;
import org.miaixz.bus.core.center.date.printer.DatePrinter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.DateException;

public interface PositionDateParser
extends DateParser,
DatePrinter {
    default public Date parse(CharSequence source, ParsePosition pos) {
        return this.parseCalendar(source, pos, Keys.getBoolean("bus.date.lenient", false)).getTime();
    }

    public boolean parse(CharSequence var1, ParsePosition var2, Calendar var3);

    default public Calendar parseCalendar(CharSequence source, ParsePosition pos, boolean lenient) {
        Assert.notBlank(source, "Date str must be not blank!", new Object[0]);
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        if (this.parse(source.toString(), pos, calendar)) {
            return calendar;
        }
        throw new DateException("Parse [{}] with format [{}] error, at: {}", source, this.getPattern(), pos.getErrorIndex());
    }
}

