/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.miaixz.bus.core.xyz.ExceptionKit;

@FunctionalInterface
public interface BiPredicateX<T, U>
extends BiPredicate<T, U>,
Serializable {
    public boolean testing(T var1, U var2) throws Throwable;

    @Override
    default public boolean test(T t, U u) {
        try {
            return this.testing(t, u);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    @Override
    default public BiPredicateX<T, U> and(BiPredicateX<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) && other.test(t, u);
    }

    @Override
    default public BiPredicateX<T, U> negate() {
        return (t, u) -> !this.test(t, u);
    }

    @Override
    default public BiPredicateX<T, U> or(BiPredicateX<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) || other.test(t, u);
    }
}

