/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.stream;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.miaixz.bus.core.center.map.multi.RowKeyTable;
import org.miaixz.bus.core.center.map.multi.Table;
import org.miaixz.bus.core.center.set.ConcurrentHashSet;
import org.miaixz.bus.core.center.stream.EasyStream;
import org.miaixz.bus.core.center.stream.EnhancedWrappedStream;
import org.miaixz.bus.core.xyz.CollectorKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class EntryStream<K, V>
extends EnhancedWrappedStream<Map.Entry<K, V>, EntryStream<K, V>> {
    private static final Map.Entry<?, ?> EMPTY_ENTRY = new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);

    EntryStream(Stream<Map.Entry<K, V>> stream) {
        super(stream);
    }

    public static <K, V> EntryStream<K, V> merge(Iterable<K> keys, Iterable<V> values) {
        boolean hasKeys = ObjectKit.isNotNull(keys);
        boolean hasValues = ObjectKit.isNotNull(values);
        if (!hasKeys && !hasValues) {
            return EntryStream.empty();
        }
        if (hasKeys && !hasValues) {
            return EntryStream.of(keys, Function.identity(), k -> null);
        }
        if (!hasKeys) {
            return EntryStream.of(values, v -> null, Function.identity());
        }
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>();
        Iterator<K> keyItr = keys.iterator();
        Iterator<V> valueItr = values.iterator();
        while (keyItr.hasNext() || valueItr.hasNext()) {
            entries.add(EntryStream.ofEntry(keyItr.hasNext() ? (K)keyItr.next() : null, valueItr.hasNext() ? (V)valueItr.next() : null));
        }
        return EntryStream.of(entries);
    }

    public static <K, V> EntryStream<K, V> of(Map<K, V> map) {
        return ObjectKit.isNull(map) ? EntryStream.empty() : EntryStream.of(map.entrySet());
    }

    public static <K, V> EntryStream<K, V> of(Iterable<? extends Map.Entry<K, V>> entries) {
        return ObjectKit.isNull(entries) ? EntryStream.empty() : EntryStream.of(StreamSupport.stream(entries.spliterator(), false));
    }

    public static <T, K, V> EntryStream<K, V> of(Iterable<T> source, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        if (ObjectKit.isNull(source)) {
            return EntryStream.empty();
        }
        Stream<Map.Entry<K, V>> stream = StreamSupport.stream(source.spliterator(), false).map((? super T t) -> EntryStream.ofEntry(keyMapper.apply(t), valueMapper.apply(t)));
        return new EntryStream<K, V>(stream);
    }

    public static <K, V> EntryStream<K, V> of(Stream<? extends Map.Entry<K, V>> stream) {
        return ObjectKit.isNull(stream) ? EntryStream.empty() : new EntryStream<K, V>(stream.map(EntryStream::ofEntry));
    }

    public static <K, V> EntryStream<K, V> empty() {
        return new EntryStream<K, V>(Stream.empty());
    }

    static <K, V> Map.Entry<K, V> ofEntry(Map.Entry<K, V> entry) {
        return ObjectKit.defaultIfNull(entry, e -> EntryStream.ofEntry(e.getKey(), e.getValue()), EMPTY_ENTRY);
    }

    static <K, V> Map.Entry<K, V> ofEntry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate data %s", u));
        };
    }

    public EntryStream<K, V> distinctByKey() {
        ConcurrentHashSet accessed = new ConcurrentHashSet(16);
        return this.wrap((Stream)this.stream.filter((? super T e) -> {
            Object key = e.getKey();
            if (accessed.contains(key)) {
                return false;
            }
            accessed.add(key);
            return true;
        }));
    }

    public EntryStream<K, V> distinctByValue() {
        ConcurrentHashSet accessed = new ConcurrentHashSet(16);
        return this.wrap((Stream)this.stream.filter((? super T e) -> {
            Object val = e.getValue();
            if (accessed.contains(val)) {
                return false;
            }
            accessed.add(val);
            return true;
        }));
    }

    public EntryStream<K, V> filter(BiPredicate<? super K, ? super V> filter) {
        Objects.requireNonNull(filter);
        return (EntryStream)super.filter((T e) -> filter.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public EntryStream<K, V> filterByKey(Predicate<? super K> filter) {
        Objects.requireNonNull(filter);
        return (EntryStream)super.filter((T e) -> filter.test((Object)e.getKey()));
    }

    public EntryStream<K, V> filterByValue(Predicate<? super V> filter) {
        Objects.requireNonNull(filter);
        return (EntryStream)super.filter((T e) -> filter.test((Object)e.getValue()));
    }

    public EntryStream<K, V> nonNullKeyValue() {
        return (EntryStream)super.filter((T e) -> ObjectKit.isNotNull(e) && ObjectKit.isNotNull(e.getKey()) && ObjectKit.isNotNull(e.getValue()));
    }

    public EntryStream<K, V> nonNullKey() {
        return (EntryStream)super.filter((T e) -> ObjectKit.isNotNull(e) && ObjectKit.isNotNull(e.getKey()));
    }

    public EntryStream<K, V> nonNullValue() {
        return (EntryStream)super.filter((T e) -> ObjectKit.isNotNull(e) && ObjectKit.isNotNull(e.getValue()));
    }

    public EntryStream<K, V> peekKey(Consumer<? super K> consumer) {
        Objects.requireNonNull(consumer);
        return (EntryStream)super.peek((T e) -> consumer.accept((Object)e.getKey()));
    }

    public EntryStream<K, V> peekValue(Consumer<? super V> consumer) {
        Objects.requireNonNull(consumer);
        return (EntryStream)super.peek((T e) -> consumer.accept((Object)e.getValue()));
    }

    public EntryStream<K, V> sortByKey(Comparator<? super K> comparator) {
        Objects.requireNonNull(comparator);
        return (EntryStream)this.sorted(Map.Entry.comparingByKey(comparator));
    }

    public EntryStream<K, V> sortByValue(Comparator<? super V> comparator) {
        Objects.requireNonNull(comparator);
        return (EntryStream)this.sorted(Map.Entry.comparingByValue(comparator));
    }

    public EntryStream<K, V> push(K key, V value) {
        return this.wrap((Stream)Stream.concat(this.stream, Stream.of(EntryStream.ofEntry(key, value))));
    }

    public EntryStream<K, V> unshift(K key, V value) {
        return this.wrap((Stream)Stream.concat(Stream.of(EntryStream.ofEntry(key, value)), this.stream));
    }

    @Override
    public EntryStream<K, V> append(Iterable<? extends Map.Entry<K, V>> entries) {
        if (IteratorKit.isEmpty(entries)) {
            return this;
        }
        Stream<Map.Entry> contacted = StreamSupport.stream(entries.spliterator(), this.isParallel()).map(EntryStream::ofEntry);
        return this.wrap((Stream)Stream.concat(this.stream, contacted));
    }

    @Override
    public EntryStream<K, V> prepend(Iterable<? extends Map.Entry<K, V>> entries) {
        if (IteratorKit.isEmpty(entries)) {
            return this;
        }
        Stream<Map.Entry> contacted = StreamSupport.stream(entries.spliterator(), this.isParallel()).map(EntryStream::ofEntry);
        return this.wrap((Stream)Stream.concat(contacted, this.stream));
    }

    public EasyStream<V> toValueStream() {
        return EasyStream.of(this.stream.map(Map.Entry::getValue));
    }

    public EasyStream<K> toKeyStream() {
        return EasyStream.of(this.stream.map(Map.Entry::getKey));
    }

    public <N> EntryStream<N, V> mapKeys(Function<? super K, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryStream<K, V>(this.stream.map((? super T e) -> EntryStream.ofEntry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <N> EntryStream<K, N> mapValues(Function<? super V, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return new EntryStream<K, V>(this.stream.map((? super T e) -> EntryStream.ofEntry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    @Override
    public <R> EasyStream<R> map(Function<? super Map.Entry<K, V>, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return EasyStream.of(this.stream.map(mapper));
    }

    public <N> EasyStream<N> map(BiFunction<? super K, ? super V, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return EasyStream.of(this.stream.map((? super T e) -> mapper.apply((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    public <R> EasyStream<R> flatMap(Function<? super Map.Entry<K, V>, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return EasyStream.of(this.stream.flatMap(mapper));
    }

    public <N> EntryStream<N, V> flatMapKey(Function<? super K, Stream<? extends N>> keyMapper) {
        Objects.requireNonNull(keyMapper);
        return new EntryStream<K, V>(this.stream.flatMap((? super T e) -> ((Stream)keyMapper.apply((Object)e.getKey())).map((? super T newKey) -> EntryStream.ofEntry(newKey, e.getValue()))));
    }

    public <N> EntryStream<K, N> flatMapValue(Function<? super V, Stream<? extends N>> valueMapper) {
        Objects.requireNonNull(valueMapper);
        return new EntryStream<K, V>(this.stream.flatMap((? super T e) -> ((Stream)valueMapper.apply((Object)e.getValue())).map((? super T newVal) -> EntryStream.ofEntry(e.getKey(), newVal))));
    }

    public Map<K, V> toMap(Supplier<Map<K, V>> mapFactory, BinaryOperator<V> operator) {
        Objects.requireNonNull(mapFactory);
        Objects.requireNonNull(operator);
        return super.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, operator, mapFactory));
    }

    public Map<K, V> toMap(Supplier<Map<K, V>> mapFactory) {
        Objects.requireNonNull(mapFactory);
        return super.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (t1, t2) -> t2, mapFactory));
    }

    public Map<K, V> toMap() {
        return super.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <N> Table<N, K, V> toTable(BiFunction<? super K, ? super V, ? extends N> rowKeyMapper, Supplier<Map<K, V>> colMapFactory, BinaryOperator<V> operator) {
        Objects.requireNonNull(rowKeyMapper);
        Objects.requireNonNull(colMapFactory);
        Objects.requireNonNull(operator);
        Map rawMap = this.collect(Collectors.groupingBy(e -> rowKeyMapper.apply((Object)e.getKey(), (Object)e.getValue()), HashMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, operator, colMapFactory)));
        return new RowKeyTable(rawMap, colMapFactory::get);
    }

    public <N> Table<N, K, V> toTable(BiFunction<? super K, ? super V, ? extends N> rowKeyMapper) {
        return this.toTable(rowKeyMapper, HashMap::new, EntryStream.throwingMerger());
    }

    public <N> Table<N, K, V> toTableByKey(Function<? super K, ? extends N> rowKeyMapper, Supplier<Map<K, V>> colMapFactory, BinaryOperator<V> operator) {
        return this.toTable((k, v) -> rowKeyMapper.apply((Object)k), colMapFactory, operator);
    }

    public <N> Table<N, K, V> toTableByKey(Function<? super K, ? extends N> rowKeyMapper) {
        return this.toTable((k, v) -> rowKeyMapper.apply((Object)k));
    }

    public <N> Table<N, K, V> toTableByValue(Function<? super V, ? extends N> rowKeyMapper, Supplier<Map<K, V>> colMapFactory, BinaryOperator<V> operator) {
        return this.toTable((k, v) -> rowKeyMapper.apply((Object)v), colMapFactory, operator);
    }

    public <N> Table<N, K, V> toTableByValue(Function<? super V, ? extends N> rowKeyMapper) {
        return this.toTable((k, v) -> rowKeyMapper.apply((Object)v));
    }

    public Map<K, List<V>> groupByKey() {
        return this.groupByKey(Collectors.toList());
    }

    public <C extends Collection<V>> Map<K, C> groupByKey(Collector<V, ?, C> collector) {
        return this.groupByKey(HashMap::new, collector);
    }

    public <C extends Collection<V>, M extends Map<K, C>> M groupByKey(Supplier<M> mapFactory, Collector<V, ?, C> collector) {
        return (M)((Map)super.collect(Collectors.groupingBy(Map.Entry::getKey, mapFactory, CollectorKit.transform(ArrayList::new, s -> (Collection)s.stream().map(Map.Entry::getValue).collect(collector)))));
    }

    public void forEach(BiConsumer<K, V> consumer) {
        Objects.requireNonNull(consumer);
        super.forEach((? super T e) -> consumer.accept(e.getKey(), e.getValue()));
    }

    public EntryStream<V, K> inverse() {
        return new EntryStream<K, V>(this.stream.map((? super T e) -> EntryStream.ofEntry(e.getValue(), e.getKey())));
    }

    public <R> R collectKeys(Collector<K, ?, R> collector) {
        return this.toKeyStream().collect(collector);
    }

    public <R> R collectValues(Collector<V, ?, R> collector) {
        return this.toValueStream().collect(collector);
    }

    public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        return super.anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return super.allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate);
        return super.noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public EntryStream<K, V> wrap(Stream<Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(stream);
    }
}

