/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.nio.charset.Charset;
import java.util.Objects;

public class Crockford {
    protected static final int MASK_8BITS = 255;
    private static final Charset DEFAULT_CHARSET = org.miaixz.bus.core.lang.Charset.UTF_8;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int MASK_5BITS = 31;
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte[] ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 74, 75, 77, 78, 80, 81, 82, 83, 84, 86, 87, 88, 89, 90};
    private final int decodeSize;
    private final int encodeSize;
    private final boolean usePaddingCharacter;
    protected byte[] buffer;
    protected int pos;
    protected boolean eof;
    protected int modulus;
    private long bitWorkArea;

    public Crockford() {
        this(false);
    }

    public Crockford(boolean usePaddingCharacter) {
        this.usePaddingCharacter = usePaddingCharacter;
        this.encodeSize = 8;
        this.decodeSize = this.encodeSize - 1;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInAlphabet(String base32) {
        return Crockford.isInAlphabet(base32.getBytes(DEFAULT_CHARSET), true);
    }

    public static boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
        for (byte b : arrayOctet) {
            if (Crockford.isInAlphabet(b) || allowWSPad && (b == 61 || Crockford.isWhiteSpace(b))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInAlphabet(byte octet) {
        return Crockford.decode(octet) != -1;
    }

    public static void writeCrockford(char[] buffer, long value, int count, int offset) {
        for (int i = 0; i < count; ++i) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = (char)ENCODE_TABLE[index];
        }
    }

    public static void appendCrockford(StringBuilder builder, long value, int count) {
        for (int i = count - 1; i >= 0; --i) {
            int index = (int)(value >>> i * 5 & 0x1FL);
            builder.append(ENCODE_TABLE[index]);
        }
    }

    public static long parseCrockford(String input) {
        Objects.requireNonNull(input, "input must not be null!");
        int length = input.length();
        if (length > 12) {
            throw new IllegalArgumentException("input length must not exceed 12 but was " + length + "!");
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            char current = input.charAt(i);
            byte value = Crockford.decode((byte)current);
            if (value < 0) {
                throw new IllegalArgumentException("Illegal character '" + current + "'!");
            }
            result |= (long)value << (length - 1 - i) * 5;
        }
        return result;
    }

    private static byte decode(byte octet) {
        switch (octet) {
            case 48: 
            case 79: 
            case 111: {
                return 0;
            }
            case 49: 
            case 73: 
            case 76: 
            case 105: 
            case 108: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
            case 71: 
            case 103: {
                return 16;
            }
            case 72: 
            case 104: {
                return 17;
            }
            case 74: 
            case 106: {
                return 18;
            }
            case 75: 
            case 107: {
                return 19;
            }
            case 77: 
            case 109: {
                return 20;
            }
            case 78: 
            case 110: {
                return 21;
            }
            case 80: 
            case 112: {
                return 22;
            }
            case 81: 
            case 113: {
                return 23;
            }
            case 82: 
            case 114: {
                return 24;
            }
            case 83: 
            case 115: {
                return 25;
            }
            case 84: 
            case 116: {
                return 26;
            }
            case 85: 
            case 86: 
            case 117: 
            case 118: {
                return 27;
            }
            case 87: 
            case 119: {
                return 28;
            }
            case 88: 
            case 120: {
                return 29;
            }
            case 89: 
            case 121: {
                return 30;
            }
            case 90: 
            case 122: {
                return 31;
            }
        }
        return -1;
    }

    int available() {
        return this.buffer != null ? this.pos : 0;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[8192];
            this.pos = 0;
        } else {
            byte[] b = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
            this.buffer = b;
        }
    }

    protected void ensureBufferSize(int size) {
        if (this.buffer == null || this.buffer.length < this.pos + size) {
            this.resizeBuffer();
        }
    }

    int readResults(byte[] b) {
        if (this.buffer != null) {
            int len = this.available();
            System.arraycopy(this.buffer, 0, b, 0, len);
            this.buffer = null;
            return len;
        }
        return this.eof ? -1 : 0;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.modulus = 0;
        this.eof = false;
    }

    public String encodeToString(String pArray) {
        return this.encodeToString(pArray.getBytes(DEFAULT_CHARSET));
    }

    public String encodeToString(byte[] pArray) {
        return new String(this.encode(pArray), DEFAULT_CHARSET);
    }

    public String decodeToString(String pArray) {
        return this.decodeToString(pArray.getBytes(DEFAULT_CHARSET));
    }

    public String decodeToString(byte[] pArray) {
        return new String(this.decode(pArray), DEFAULT_CHARSET);
    }

    public byte[] decode(String pArray) {
        return this.decode(pArray.getBytes(DEFAULT_CHARSET));
    }

    public byte[] encode(String pArray) {
        return this.encode(pArray.getBytes(DEFAULT_CHARSET));
    }

    public byte[] decode(byte[] pArray) {
        this.reset();
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        this.decode(pArray, 0, pArray.length);
        this.decode(pArray, 0, -1);
        byte[] result = new byte[this.pos];
        this.readResults(result);
        return result;
    }

    public byte[] encode(byte[] pArray) {
        this.reset();
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        this.encode(pArray, 0, pArray.length);
        this.encode(pArray, 0, -1);
        byte[] buf = new byte[this.pos];
        this.readResults(buf);
        return buf;
    }

    public long getEncodedLength(byte[] pArray) {
        return (long)((pArray.length + 5 - 1) / 5) * 8L;
    }

    void decode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte b;
            if ((b = in[inPos++]) == 61) {
                this.eof = true;
                break;
            }
            this.ensureBufferSize(this.decodeSize);
            if (!Crockford.isInAlphabet(b)) continue;
            byte result = Crockford.decode(b);
            this.modulus = (this.modulus + 1) % 8;
            this.bitWorkArea = (this.bitWorkArea << 5) + (long)result;
            if (this.modulus != 0) continue;
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 32 & 0xFFL);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
        }
        if (this.eof && this.modulus >= 2) {
            this.ensureBufferSize(this.decodeSize);
            switch (this.modulus) {
                case 2: {
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    this.bitWorkArea >>= 4;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    this.bitWorkArea >>= 1;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    this.bitWorkArea >>= 6;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    this.bitWorkArea >>= 3;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 24 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFFL);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFFL);
                }
            }
        }
    }

    void encode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
            if (0 == this.modulus) {
                return;
            }
            this.ensureBufferSize(this.encodeSize);
            int savedPos = this.pos;
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 3) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea << 2) & 0x1F];
                    if (!this.usePaddingCharacter) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 11) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 6) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 1) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea << 4) & 0x1F];
                    if (!this.usePaddingCharacter) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 19) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 14) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 9) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 4) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea << 1) & 0x1F];
                    if (!this.usePaddingCharacter) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 4: {
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 27) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 22) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 17) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 12) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 7) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 2) & 0x1F];
                    this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea << 3) & 0x1F];
                    if (!this.usePaddingCharacter) break;
                    this.buffer[this.pos++] = 61;
                }
            }
        } else {
            for (int i = 0; i < inAvail; ++i) {
                this.ensureBufferSize(this.encodeSize);
                this.modulus = (this.modulus + 1) % 5;
                int b = in[inPos++];
                if (b < 0) {
                    b += 256;
                }
                this.bitWorkArea = (this.bitWorkArea << 8) + (long)b;
                if (0 != this.modulus) continue;
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 35) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 30) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 25) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 20) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 15) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 10) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)(this.bitWorkArea >> 5) & 0x1F];
                this.buffer[this.pos++] = ENCODE_TABLE[(int)this.bitWorkArea & 0x1F];
            }
        }
    }
}

