/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.nio.charset.Charset;
import org.miaixz.bus.core.codec.binary.provider.Base16Provider;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Hex {
    public static char[] encode(byte[] data) {
        return Hex.encode(data, true);
    }

    public static char[] encode(String text, Charset charset) {
        return Hex.encode(ByteKit.toBytes(text, charset), true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        if (null == data) {
            return null;
        }
        return (toLowerCase ? Base16Provider.CODEC_LOWER : Base16Provider.CODEC_UPPER).encode(data);
    }

    public static String encodeString(byte[] data) {
        return Hex.encodeString(data, true);
    }

    public static String encodeString(byte[] data, boolean toLowerCase) {
        return StringKit.toString(Hex.encode(data, toLowerCase), org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeString(CharSequence data) {
        return Hex.encodeString(data, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeString(CharSequence data, Charset charset) {
        return Hex.encodeString(ByteKit.toBytes(data, charset), true);
    }

    public static byte[] decode(CharSequence data) {
        return Base16Provider.CODEC_LOWER.decode(data);
    }

    public static byte[] decode(char[] data) {
        return Hex.decode(String.valueOf(data));
    }

    public static String decodeString(CharSequence data) {
        return Hex.decodeString(data, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeString(CharSequence data, Charset charset) {
        if (StringKit.isEmpty(data)) {
            return StringKit.toStringOrNull(data);
        }
        return StringKit.toString(Hex.decode(data), charset);
    }

    public static String decodeString(char[] data, Charset charset) {
        return StringKit.toString(Hex.decode(data), charset);
    }
}

