/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.SerializeKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ArrayConverter
extends AbstractConverter
implements MatcherConverter {
    private static final long serialVersionUID = 2852263350173L;
    public static final ArrayConverter INSTANCE = new ArrayConverter();
    private boolean ignoreElementError;

    public ArrayConverter() {
        this(false);
    }

    public ArrayConverter(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Class<?> targetComponentType = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
        return value.getClass().isArray() ? this.convertArrayToArray(targetComponentType, value) : this.convertObjectToArray(targetComponentType, value);
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return rawType.isArray();
    }

    public void setIgnoreElementError(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    private Object convertArrayToArray(Class<?> targetComponentType, Object array) {
        Class<?> valueComponentType = ArrayKit.getComponentType(array);
        if (valueComponentType == targetComponentType) {
            return array;
        }
        int len = ArrayKit.length(array);
        Object result = Array.newInstance(targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Class<?> targetComponentType, Object value) {
        if (value instanceof CharSequence) {
            if (targetComponentType == Character.TYPE || targetComponentType == Character.class) {
                return this.convertArrayToArray(targetComponentType, value.toString().toCharArray());
            }
            if (targetComponentType == Byte.TYPE) {
                String text = value.toString();
                if (Base64.isTypeBase64(text)) {
                    return Base64.decode(value.toString());
                }
                return text.getBytes();
            }
            String[] strings = StringKit.splitToArray(value.toString(), ",");
            return this.convertArrayToArray(targetComponentType, strings);
        }
        if (value instanceof Iterator) {
            value = IteratorKit.asIterable((Iterator)((Object)value));
        }
        Object result = value instanceof Iterable ? this.convertIterableToArray(targetComponentType, value) : (value instanceof Number && Byte.TYPE == targetComponentType ? (Object)ByteKit.toBytes((Number)((Object)value)) : (value instanceof Serializable && Byte.TYPE == targetComponentType ? (Object)SerializeKit.serialize(value) : this.convertToSingleElementArray(targetComponentType, value)));
        return result;
    }

    private Object convertIterableToArray(Class<?> targetComponentType, Iterable<?> value) {
        Object result;
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            result = Array.newInstance(targetComponentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(targetComponentType, element));
                ++i;
            }
        } else {
            ArrayList<?> list = ListKit.of(value);
            int size = list.size();
            result = Array.newInstance(targetComponentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Class<?> targetComponentType, Object value) {
        Object[] singleElementArray = ArrayKit.newArray(targetComponentType, 1);
        singleElementArray[0] = this.convertComponentType(targetComponentType, value);
        return singleElementArray;
    }

    private Object convertComponentType(Class<?> targetComponentType, Object value) {
        return Convert.convertWithCheck(targetComponentType, value, null, this.ignoreElementError);
    }
}

