/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class CollectionConverter
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 2852266827800L;
    public static CollectionConverter INSTANCE = new CollectionConverter();

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public Collection<?> convert(Type targetType, Object value) {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        return this.convert(targetType, TypeKit.getTypeArgument(targetType), value);
    }

    public Collection<?> convert(Type collectionType, Type elementType, Object value) {
        Collection<?> collection = CollKit.create(TypeKit.getClass(collectionType), TypeKit.getClass(elementType));
        return CollKit.addAll(collection, value, elementType);
    }
}

