/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Type;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Resolver;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class DateConverter
extends AbstractConverter
implements MatcherConverter {
    private static final long serialVersionUID = 2852267950550L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Date.class.isAssignableFrom(rawType);
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime date;
        if (value == null || value instanceof CharSequence && StringKit.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateKit.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateKit.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String values = this.convertToString(value);
        DateTime dateTime = date = StringKit.isBlank(this.format) ? Resolver.parse(values) : Resolver.parse((CharSequence)values, this.format);
        if (null != date) {
            return this.wrap(targetClass, date);
        }
        throw new ConvertException("Can not support {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, Date date) {
        if (targetClass == date.getClass()) {
            return date;
        }
        return this.wrap(targetClass, date.getTime());
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateKit.date(mills);
        }
        String dateClassName = targetClass.getName();
        if (dateClassName.startsWith("java.sql.")) {
            return DateKit.SQL.wrap(targetClass, mills);
        }
        throw new ConvertException("Unsupported target Date type: {}", targetClass.getName());
    }
}

