/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.lang.Enumers;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.EnumKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;

public class EnumConverter
extends AbstractConverter
implements MatcherConverter {
    private static final long serialVersionUID = 2852268818368L;
    public static final EnumConverter INSTANCE = new EnumConverter();
    private static final WeakConcurrentMap<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new WeakConcurrentMap();

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        Enumers first;
        if (value == null) {
            return null;
        }
        if (Enumers.class.isAssignableFrom(enumClass) && null != (first = (Enumers)EnumKit.getEnumAt(enumClass, 0))) {
            if (value instanceof Integer) {
                return (Enum)first.from((Integer)value);
            }
            if (value instanceof String) {
                return (Enum)first.from(value.toString());
            }
        }
        try {
            Map<Class<?>, Method> methodMap = EnumConverter.getMethodMap(enumClass);
            if (MapKit.isNotEmpty(methodMap)) {
                Class<?> valueClass = value.getClass();
                for (Map.Entry<Class<?>, Method> entry : methodMap.entrySet()) {
                    if (!ClassKit.isAssignable(entry.getKey(), valueClass)) continue;
                    return (Enum)MethodKit.invokeStatic(entry.getValue(), value);
                }
            }
        }
        catch (Exception methodMap) {
            // empty catch block
        }
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumKit.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getMethodMap(Class<?> enumClass) {
        return VALUE_OF_METHOD_CACHE.computeIfAbsent(enumClass, key -> Arrays.stream(enumClass.getMethods()).filter(ModifierKit::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> !"valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (k1, k2) -> k1)));
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return rawType.isEnum();
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, targetClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(targetClass, this.convertToString(value));
        }
        if (null != enumValue) {
            return enumValue;
        }
        throw new ConvertException("Can not support {} to {}", value, targetClass);
    }
}

